/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class SpriteAwareVertexBuilder
implements IVertexBuilder {
    private final IVertexBuilder vertexBuilder;
    private final TextureAtlasSprite atlasSprite;

    public SpriteAwareVertexBuilder(IVertexBuilder bufferIn, TextureAtlasSprite spriteIn) {
        this.vertexBuilder = bufferIn;
        this.atlasSprite = spriteIn;
    }

    @Override
    public IVertexBuilder pos(double x, double y, double z) {
        return this.vertexBuilder.pos(x, y, z);
    }

    @Override
    public IVertexBuilder color(int red, int green, int blue, int alpha) {
        return this.vertexBuilder.color(red, green, blue, alpha);
    }

    @Override
    public IVertexBuilder tex(float u, float v) {
        return this.vertexBuilder.tex(this.atlasSprite.getInterpolatedU(u * 16.0f), this.atlasSprite.getInterpolatedV(v * 16.0f));
    }

    @Override
    public IVertexBuilder overlay(int u, int v) {
        return this.vertexBuilder.overlay(u, v);
    }

    @Override
    public IVertexBuilder lightmap(int u, int v) {
        return this.vertexBuilder.lightmap(u, v);
    }

    @Override
    public IVertexBuilder normal(float x, float y, float z) {
        return this.vertexBuilder.normal(x, y, z);
    }

    @Override
    public void endVertex() {
        this.vertexBuilder.endVertex();
    }

    @Override
    public void addVertex(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        this.vertexBuilder.addVertex(x, y, z, red, green, blue, alpha, this.atlasSprite.getInterpolatedU(texU * 16.0f), this.atlasSprite.getInterpolatedV(texV * 16.0f), overlayUV, lightmapUV, normalX, normalY, normalZ);
    }
}

