/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;

public class RisingParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteWithAge;
    private final double yAccel;

    protected RisingParticle(ClientWorld world, double x, double y, double z, float defaultMotionMultX, float defaultMotionMultY, float defaultMotionMultZ, double motionX, double motionY, double motionZ, float scale, IAnimatedSprite spriteWithAge, float colorMult, int maxAge, double yAccel, boolean canCollide) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        float f;
        this.yAccel = yAccel;
        this.spriteWithAge = spriteWithAge;
        this.motionX *= (double)defaultMotionMultX;
        this.motionY *= (double)defaultMotionMultY;
        this.motionZ *= (double)defaultMotionMultZ;
        this.motionX += motionX;
        this.motionY += motionY;
        this.motionZ += motionZ;
        this.particleRed = f = world.rand.nextFloat() * colorMult;
        this.particleGreen = f;
        this.particleBlue = f;
        this.particleScale *= 0.75f * scale;
        this.maxAge = (int)((double)maxAge / ((double)world.rand.nextFloat() * 0.8 + 0.2));
        this.maxAge = (int)((float)this.maxAge * scale);
        this.maxAge = Math.max(this.maxAge, 1);
        this.selectSpriteWithAge(spriteWithAge);
        this.canCollide = canCollide;
    }

    @Override
    public IParticleRenderType getRenderType() {
        return IParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public float getScale(float scaleFactor) {
        return this.particleScale * MathHelper.clamp(((float)this.age + scaleFactor) / (float)this.maxAge * 32.0f, 0.0f, 1.0f);
    }

    @Override
    public void tick() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.age++ >= this.maxAge) {
            this.setExpired();
        } else {
            this.selectSpriteWithAge(this.spriteWithAge);
            this.motionY += this.yAccel;
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.posY == this.prevPosY) {
                this.motionX *= 1.1;
                this.motionZ *= 1.1;
            }
            this.motionX *= (double)0.96f;
            this.motionY *= (double)0.96f;
            this.motionZ *= (double)0.96f;
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
            }
        }
    }
}

