/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.optifine.CustomLoadingScreen;
import net.optifine.CustomLoadingScreens;

public class WorkingScreen
extends Screen
implements IProgressUpdate {
    @Nullable
    private ITextComponent field_238648_a_;
    @Nullable
    private ITextComponent stage;
    private int progress;
    private boolean doneWorking;
    private CustomLoadingScreen customLoadingScreen = CustomLoadingScreens.getCustomLoadingScreen();

    public WorkingScreen() {
        super(NarratorChatListener.EMPTY);
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void displaySavingString(ITextComponent component) {
        this.resetProgressAndMessage(component);
    }

    @Override
    public void resetProgressAndMessage(ITextComponent component) {
        this.field_238648_a_ = component;
        this.displayLoadingString(new TranslationTextComponent("progress.working"));
    }

    @Override
    public void displayLoadingString(ITextComponent component) {
        this.stage = component;
        this.setLoadingProgress(0);
    }

    @Override
    public void setLoadingProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setDoneWorking() {
        this.doneWorking = true;
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.doneWorking) {
            this.minecraft.displayGuiScreen(null);
        } else {
            if (this.customLoadingScreen != null && this.minecraft.world == null) {
                this.customLoadingScreen.drawBackground(this.width, this.height);
            } else {
                this.renderBackground(matrices);
            }
            if (this.progress > 0) {
                if (this.field_238648_a_ != null) {
                    WorkingScreen.drawCenteredString(matrices, this.font, this.field_238648_a_, this.width / 2, 70, 0xFFFFFF);
                }
                if (this.stage != null && this.progress != 0) {
                    WorkingScreen.drawCenteredString(matrices, this.font, new StringTextComponent("").append(this.stage).appendString(" " + this.progress + "%"), this.width / 2, 90, 0xFFFFFF);
                }
            }
            super.render(matrices, mouseX, mouseY, delta);
        }
    }
}

