/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ReadBookScreen
extends Screen {
    public static final IBookInfo EMPTY_BOOK = new IBookInfo(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public ITextProperties func_230456_a_(int p_230456_1_) {
            return ITextProperties.field_240651_c_;
        }
    };
    public static final ResourceLocation BOOK_TEXTURES = new ResourceLocation("textures/gui/book.png");
    private IBookInfo bookInfo;
    private int currPage;
    private List<IReorderingProcessor> cachedPageLines = Collections.emptyList();
    private int cachedPage = -1;
    private ITextComponent field_243344_s = StringTextComponent.EMPTY;
    private ChangePageButton buttonNextPage;
    private ChangePageButton buttonPreviousPage;
    private final boolean pageTurnSounds;

    public ReadBookScreen(IBookInfo bookInfoIn) {
        this(bookInfoIn, true);
    }

    public ReadBookScreen() {
        this(EMPTY_BOOK, false);
    }

    private ReadBookScreen(IBookInfo bookInfoIn, boolean pageTurnSoundsIn) {
        super(NarratorChatListener.EMPTY);
        this.bookInfo = bookInfoIn;
        this.pageTurnSounds = pageTurnSoundsIn;
    }

    public void func_214155_a(IBookInfo p_214155_1_) {
        this.bookInfo = p_214155_1_;
        this.currPage = MathHelper.clamp(this.currPage, 0, p_214155_1_.getPageCount());
        this.updateButtons();
        this.cachedPage = -1;
    }

    public boolean showPage(int pageNum) {
        int i = MathHelper.clamp(pageNum, 0, this.bookInfo.getPageCount() - 1);
        if (i != this.currPage) {
            this.currPage = i;
            this.updateButtons();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected boolean showPage2(int pageNum) {
        return this.showPage(pageNum);
    }

    @Override
    protected void init() {
        this.addDoneButton();
        this.addChangePageButtons();
    }

    protected void addDoneButton() {
        this.addButton(new Button(this.width / 2 - 100, 196, 200, 20, DialogTexts.GUI_DONE, p_214161_1_ -> this.minecraft.displayGuiScreen(null)));
    }

    protected void addChangePageButtons() {
        int i = (this.width - 192) / 2;
        int j = 2;
        this.buttonNextPage = this.addButton(new ChangePageButton(i + 116, 159, true, p_214159_1_ -> this.nextPage(), this.pageTurnSounds));
        this.buttonPreviousPage = this.addButton(new ChangePageButton(i + 43, 159, false, p_214158_1_ -> this.previousPage(), this.pageTurnSounds));
        this.updateButtons();
    }

    private int getPageCount() {
        return this.bookInfo.getPageCount();
    }

    protected void previousPage() {
        if (this.currPage > 0) {
            --this.currPage;
        }
        this.updateButtons();
    }

    protected void nextPage() {
        if (this.currPage < this.getPageCount() - 1) {
            ++this.currPage;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.visible = this.currPage < this.getPageCount() - 1;
        this.buttonPreviousPage.visible = this.currPage > 0;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 266: {
                this.buttonPreviousPage.onPress();
                return true;
            }
            case 267: {
                this.buttonNextPage.onPress();
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.minecraft.getTextureManager().bindTexture(BOOK_TEXTURES);
        int i = (this.width - 192) / 2;
        int j = 2;
        this.blit(matrices, i, 2, 0, 0, 192, 192);
        if (this.cachedPage != this.currPage) {
            ITextProperties itextproperties = this.bookInfo.func_238806_b_(this.currPage);
            this.cachedPageLines = this.font.trimStringToWidth(itextproperties, 114);
            this.field_243344_s = new TranslationTextComponent("book.pageIndicator", this.currPage + 1, Math.max(this.getPageCount(), 1));
        }
        this.cachedPage = this.currPage;
        int i1 = this.font.getStringPropertyWidth(this.field_243344_s);
        this.font.func_243248_b(matrices, this.field_243344_s, i - i1 + 192 - 44, 18.0f, 0);
        int k = Math.min(14, this.cachedPageLines.size());
        for (int l = 0; l < k; ++l) {
            IReorderingProcessor ireorderingprocessor = this.cachedPageLines.get(l);
            this.font.func_238422_b_(matrices, ireorderingprocessor, i + 36, 32 + l * 9, 0);
        }
        Style style = this.func_238805_a_(mouseX, mouseY);
        if (style != null) {
            this.renderComponentHoverEffect(matrices, style, mouseX, mouseY);
        }
        super.render(matrices, mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style style;
        if (button == 0 && (style = this.func_238805_a_(mouseX, mouseY)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean handleComponentClicked(Style style) {
        ClickEvent clickevent = style.getClickEvent();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.getValue();
            try {
                int i = Integer.parseInt(s) - 1;
                return this.showPage2(i);
            }
            catch (Exception exception) {
                return false;
            }
        }
        boolean flag = super.handleComponentClicked(style);
        if (flag && clickevent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.minecraft.displayGuiScreen(null);
        }
        return flag;
    }

    @Nullable
    public Style func_238805_a_(double p_238805_1_, double p_238805_3_) {
        if (this.cachedPageLines.isEmpty()) {
            return null;
        }
        int i = MathHelper.floor(p_238805_1_ - (double)((this.width - 192) / 2) - 36.0);
        int j = MathHelper.floor(p_238805_3_ - 2.0 - 30.0);
        if (i >= 0 && j >= 0) {
            int k = Math.min(14, this.cachedPageLines.size());
            if (i <= 114 && j < 9 * k + k) {
                int l = j / 9;
                if (l >= 0 && l < this.cachedPageLines.size()) {
                    IReorderingProcessor ireorderingprocessor = this.cachedPageLines.get(l);
                    return this.minecraft.fontRenderer.getCharacterManager().func_243239_a(ireorderingprocessor, i);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static List<String> nbtPagesToStrings(CompoundNBT p_214157_0_) {
        ListNBT listnbt = p_214157_0_.getList("pages", 8).copy();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < listnbt.size(); ++i) {
            builder.add((Object)listnbt.getString(i));
        }
        return builder.build();
    }

    public static interface IBookInfo {
        public int getPageCount();

        public ITextProperties func_230456_a_(int var1);

        default public ITextProperties func_238806_b_(int p_238806_1_) {
            return p_238806_1_ >= 0 && p_238806_1_ < this.getPageCount() ? this.func_230456_a_(p_238806_1_) : ITextProperties.field_240651_c_;
        }

        public static IBookInfo func_216917_a(ItemStack p_216917_0_) {
            Item item = p_216917_0_.getItem();
            if (item == Items.WRITTEN_BOOK) {
                return new WrittenBookInfo(p_216917_0_);
            }
            return item == Items.WRITABLE_BOOK ? new UnwrittenBookInfo(p_216917_0_) : EMPTY_BOOK;
        }
    }

    public static class WrittenBookInfo
    implements IBookInfo {
        private final List<String> pages;

        public WrittenBookInfo(ItemStack p_i50616_1_) {
            this.pages = WrittenBookInfo.func_216921_b(p_i50616_1_);
        }

        private static List<String> func_216921_b(ItemStack stack) {
            CompoundNBT compoundnbt = stack.getTag();
            return compoundnbt != null && WrittenBookItem.validBookTagContents(compoundnbt) ? ReadBookScreen.nbtPagesToStrings(compoundnbt) : ImmutableList.of((Object)ITextComponent.Serializer.toJson(new TranslationTextComponent("book.invalid.tag").mergeStyle(TextFormatting.DARK_RED)));
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public ITextProperties func_230456_a_(int p_230456_1_) {
            String s = this.pages.get(p_230456_1_);
            try {
                IFormattableTextComponent itextproperties = ITextComponent.Serializer.getComponentFromJson(s);
                if (itextproperties != null) {
                    return itextproperties;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ITextProperties.func_240652_a_(s);
        }
    }

    public static class UnwrittenBookInfo
    implements IBookInfo {
        private final List<String> pages;

        public UnwrittenBookInfo(ItemStack p_i50617_1_) {
            this.pages = UnwrittenBookInfo.func_216919_b(p_i50617_1_);
        }

        private static List<String> func_216919_b(ItemStack p_216919_0_) {
            CompoundNBT compoundnbt = p_216919_0_.getTag();
            return compoundnbt != null ? ReadBookScreen.nbtPagesToStrings(compoundnbt) : ImmutableList.of();
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public ITextProperties func_230456_a_(int p_230456_1_) {
            return ITextProperties.func_240652_a_(this.pages.get(p_230456_1_));
        }
    }
}

