/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class LanguageScreen
extends SettingsScreen {
    private static final ITextComponent field_243292_c = new StringTextComponent("(").append(new TranslationTextComponent("options.languageWarning")).appendString(")").mergeStyle(TextFormatting.GRAY);
    private List list;
    private final LanguageManager languageManager;
    private OptionButton field_211832_i;
    private Button confirmSettingsBtn;

    public LanguageScreen(Screen screen, GameSettings gameSettingsObj, LanguageManager manager) {
        super(screen, gameSettingsObj, new TranslationTextComponent("options.language"));
        this.languageManager = manager;
    }

    @Override
    protected void init() {
        this.list = new List(this.minecraft);
        this.children.add(this.list);
        this.field_211832_i = this.addButton(new OptionButton(this.width / 2 - 155, this.height - 38, 150, 20, AbstractOption.FORCE_UNICODE_FONT, AbstractOption.FORCE_UNICODE_FONT.func_238152_c_(this.gameSettings), p_213037_1_ -> {
            AbstractOption.FORCE_UNICODE_FONT.nextValue(this.gameSettings);
            this.gameSettings.saveOptions();
            p_213037_1_.setMessage(AbstractOption.FORCE_UNICODE_FONT.func_238152_c_(this.gameSettings));
            this.minecraft.updateWindowSize();
        }));
        this.confirmSettingsBtn = this.addButton(new Button(this.width / 2 - 155 + 160, this.height - 38, 150, 20, DialogTexts.GUI_DONE, p_213036_1_ -> {
            List.LanguageEntry languagescreen$list$languageentry = (List.LanguageEntry)this.list.getSelected();
            if (languagescreen$list$languageentry != null && !languagescreen$list$languageentry.field_214398_b.getCode().equals(this.languageManager.getCurrentLanguage().getCode())) {
                this.languageManager.setCurrentLanguage(languagescreen$list$languageentry.field_214398_b);
                this.gameSettings.language = languagescreen$list$languageentry.field_214398_b.getCode();
                this.minecraft.reloadResources();
                this.confirmSettingsBtn.setMessage(DialogTexts.GUI_DONE);
                this.field_211832_i.setMessage(AbstractOption.FORCE_UNICODE_FONT.func_238152_c_(this.gameSettings));
                this.gameSettings.saveOptions();
            }
            this.minecraft.displayGuiScreen(this.parentScreen);
        }));
        super.init();
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.list.render(matrices, mouseX, mouseY, delta);
        LanguageScreen.drawCenteredString(matrices, this.font, this.title, this.width / 2, 16, 0xFFFFFF);
        LanguageScreen.drawCenteredString(matrices, this.font, field_243292_c, this.width / 2, this.height - 56, 0x808080);
        super.render(matrices, mouseX, mouseY, delta);
    }

    class List
    extends ExtendedList<LanguageEntry> {
        public List(Minecraft mcIn) {
            super(mcIn, LanguageScreen.this.width, LanguageScreen.this.height, 32, LanguageScreen.this.height - 65 + 4, 18);
            for (Language language : LanguageScreen.this.languageManager.getLanguages()) {
                LanguageEntry languagescreen$list$languageentry = new LanguageEntry(language);
                this.addEntry(languagescreen$list$languageentry);
                if (!LanguageScreen.this.languageManager.getCurrentLanguage().getCode().equals(language.getCode())) continue;
                this.setSelected(languagescreen$list$languageentry);
            }
            if (this.getSelected() != null) {
                this.centerScrollOn((LanguageEntry)this.getSelected());
            }
        }

        @Override
        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() + 20;
        }

        @Override
        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        @Override
        public void setSelected(@Nullable LanguageEntry entry) {
            super.setSelected(entry);
            if (entry != null) {
                NarratorChatListener.INSTANCE.say(new TranslationTextComponent("narrator.select", entry.field_214398_b).getString());
            }
        }

        @Override
        protected void renderBackground(MatrixStack p_230433_1_) {
            LanguageScreen.this.renderBackground(p_230433_1_);
        }

        @Override
        protected boolean isFocused() {
            return LanguageScreen.this.getListener() == this;
        }

        public class LanguageEntry
        extends ExtendedList.AbstractListEntry<LanguageEntry> {
            private final Language field_214398_b;

            public LanguageEntry(Language p_i50494_2_) {
                this.field_214398_b = p_i50494_2_;
            }

            @Override
            public void render(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
                String s = this.field_214398_b.toString();
                LanguageScreen.this.font.func_238406_a_(p_230432_1_, s, List.this.width / 2 - LanguageScreen.this.font.getStringWidth(s) / 2, p_230432_3_ + 1, 0xFFFFFF, true);
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    this.func_214395_a();
                    return true;
                }
                return false;
            }

            private void func_214395_a() {
                List.this.setSelected(this);
            }
        }
    }
}

