/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.util.text.TextProcessing;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;

public class ClipboardHelper {
    private final ByteBuffer buffer = BufferUtils.createByteBuffer((int)8192);

    public String getClipboardString(long window, GLFWErrorCallbackI errorCallback) {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallback);
        String s = GLFW.glfwGetClipboardString((long)window);
        s = s != null ? TextProcessing.func_238338_a_(s) : "";
        GLFWErrorCallback glfwerrorcallback1 = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)glfwerrorcallback);
        if (glfwerrorcallback1 != null) {
            glfwerrorcallback1.free();
        }
        return s;
    }

    private static void copyToClipboard(long window, ByteBuffer clipboardBuffer, byte[] clipboardContent) {
        ((Buffer)clipboardBuffer).clear();
        clipboardBuffer.put(clipboardContent);
        clipboardBuffer.put((byte)0);
        ((Buffer)clipboardBuffer).flip();
        GLFW.glfwSetClipboardString((long)window, (ByteBuffer)clipboardBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClipboardString(long window, String string) {
        byte[] abyte = string.getBytes(Charsets.UTF_8);
        int i = abyte.length + 1;
        if (i < this.buffer.capacity()) {
            ClipboardHelper.copyToClipboard(window, this.buffer, abyte);
        } else {
            ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)i);
            try {
                ClipboardHelper.copyToClipboard(window, bytebuffer, abyte);
            }
            finally {
                MemoryUtil.memFree((ByteBuffer)bytebuffer);
            }
        }
    }
}

