/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LecternBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    public static final VoxelShape BASE_SHAPE = Block.makeCuboidShape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final VoxelShape POST_SHAPE = Block.makeCuboidShape(4.0, 2.0, 4.0, 12.0, 14.0, 12.0);
    public static final VoxelShape COMMON_SHAPE = VoxelShapes.or(BASE_SHAPE, POST_SHAPE);
    public static final VoxelShape TOP_PLATE_SHAPE = Block.makeCuboidShape(0.0, 15.0, 0.0, 16.0, 15.0, 16.0);
    public static final VoxelShape COLLISION_SHAPE = VoxelShapes.or(COMMON_SHAPE, TOP_PLATE_SHAPE);
    public static final VoxelShape WEST_SHAPE = VoxelShapes.or(Block.makeCuboidShape(1.0, 10.0, 0.0, 5.333333, 14.0, 16.0), Block.makeCuboidShape(5.333333, 12.0, 0.0, 9.666667, 16.0, 16.0), Block.makeCuboidShape(9.666667, 14.0, 0.0, 14.0, 18.0, 16.0), COMMON_SHAPE);
    public static final VoxelShape NORTH_SHAPE = VoxelShapes.or(Block.makeCuboidShape(0.0, 10.0, 1.0, 16.0, 14.0, 5.333333), Block.makeCuboidShape(0.0, 12.0, 5.333333, 16.0, 16.0, 9.666667), Block.makeCuboidShape(0.0, 14.0, 9.666667, 16.0, 18.0, 14.0), COMMON_SHAPE);
    public static final VoxelShape EAST_SHAPE = VoxelShapes.or(Block.makeCuboidShape(15.0, 10.0, 0.0, 10.666667, 14.0, 16.0), Block.makeCuboidShape(10.666667, 12.0, 0.0, 6.333333, 16.0, 16.0), Block.makeCuboidShape(6.333333, 14.0, 0.0, 2.0, 18.0, 16.0), COMMON_SHAPE);
    public static final VoxelShape SOUTH_SHAPE = VoxelShapes.or(Block.makeCuboidShape(0.0, 10.0, 15.0, 16.0, 14.0, 10.666667), Block.makeCuboidShape(0.0, 12.0, 10.666667, 16.0, 16.0, 6.333333), Block.makeCuboidShape(0.0, 14.0, 6.333333, 16.0, 18.0, 2.0), COMMON_SHAPE);

    protected LecternBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.setDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateContainer.getBaseState()).with(FACING, Direction.NORTH)).with(POWERED, false)).with(HAS_BOOK, false));
    }

    @Override
    public BlockRenderType getRenderType(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public VoxelShape getRenderShape(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return COMMON_SHAPE;
    }

    @Override
    public boolean isTransparent(BlockState state) {
        return true;
    }

    @Override
    public BlockState getStateForPlacement(BlockItemUseContext context) {
        CompoundNBT compoundnbt1;
        World world = context.getWorld();
        ItemStack itemstack = context.getItem();
        CompoundNBT compoundnbt = itemstack.getTag();
        PlayerEntity playerentity = context.getPlayer();
        boolean flag = false;
        if (!world.isRemote && playerentity != null && compoundnbt != null && playerentity.canUseCommandBlock() && compoundnbt.contains("BlockEntityTag") && (compoundnbt1 = compoundnbt.getCompound("BlockEntityTag")).contains("Book")) {
            flag = true;
        }
        return (BlockState)((BlockState)this.getDefaultState().with(FACING, context.getPlacementHorizontalFacing().getOpposite())).with(HAS_BOOK, flag);
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch (state.get(FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return COMMON_SHAPE;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.with(FACING, rot.rotate(state.get(FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.toRotation(state.get(FACING)));
    }

    @Override
    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder) {
        builder.add(FACING, POWERED, HAS_BOOK);
    }

    @Override
    @Nullable
    public TileEntity createNewTileEntity(IBlockReader worldIn) {
        return new LecternTileEntity();
    }

    public static boolean tryPlaceBook(World worldIn, BlockPos pos, BlockState state, ItemStack stack) {
        if (!state.get(HAS_BOOK).booleanValue()) {
            if (!worldIn.isRemote) {
                LecternBlock.placeBook(worldIn, pos, state, stack);
            }
            return true;
        }
        return false;
    }

    private static void placeBook(World worldIn, BlockPos pos, BlockState state, ItemStack stack) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        if (tileentity instanceof LecternTileEntity) {
            LecternTileEntity lecterntileentity = (LecternTileEntity)tileentity;
            lecterntileentity.setBook(stack.split(1));
            LecternBlock.setHasBook(worldIn, pos, state, true);
            worldIn.playSound(null, pos, SoundEvents.ITEM_BOOK_PUT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void setHasBook(World worldIn, BlockPos pos, BlockState state, boolean hasBook) {
        worldIn.setBlockState(pos, (BlockState)((BlockState)state.with(POWERED, false)).with(HAS_BOOK, hasBook), 3);
        LecternBlock.notifyNeighbors(worldIn, pos, state);
    }

    public static void pulse(World worldIn, BlockPos pos, BlockState state) {
        LecternBlock.setPowered(worldIn, pos, state, true);
        worldIn.getPendingBlockTicks().scheduleTick(pos, state.getBlock(), 2);
        worldIn.playEvent(1043, pos, 0);
    }

    private static void setPowered(World worldIn, BlockPos pos, BlockState state, boolean powered) {
        worldIn.setBlockState(pos, (BlockState)state.with(POWERED, powered), 3);
        LecternBlock.notifyNeighbors(worldIn, pos, state);
    }

    private static void notifyNeighbors(World worldIn, BlockPos pos, BlockState state) {
        worldIn.notifyNeighborsOfStateChange(pos.down(), state.getBlock());
    }

    @Override
    public void tick(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        LecternBlock.setPowered(worldIn, pos, state, false);
    }

    @Override
    public void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.isIn(newState.getBlock())) {
            if (state.get(HAS_BOOK).booleanValue()) {
                this.dropBook(state, worldIn, pos);
            }
            if (state.get(POWERED).booleanValue()) {
                worldIn.notifyNeighborsOfStateChange(pos.down(), this);
            }
            super.onReplaced(state, worldIn, pos, newState, isMoving);
        }
    }

    private void dropBook(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.getTileEntity(pos);
        if (tileentity instanceof LecternTileEntity) {
            LecternTileEntity lecterntileentity = (LecternTileEntity)tileentity;
            Direction direction = state.get(FACING);
            ItemStack itemstack = lecterntileentity.getBook().copy();
            float f = 0.25f * (float)direction.getXOffset();
            float f1 = 0.25f * (float)direction.getZOffset();
            ItemEntity itementity = new ItemEntity(world, (double)pos.getX() + 0.5 + (double)f, pos.getY() + 1, (double)pos.getZ() + 0.5 + (double)f1, itemstack);
            itementity.setDefaultPickupDelay();
            world.addEntity(itementity);
            lecterntileentity.clear();
        }
    }

    @Override
    public boolean canProvidePower(BlockState state) {
        return true;
    }

    @Override
    public int getWeakPower(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.get(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP && blockState.get(POWERED) != false ? 15 : 0;
    }

    @Override
    public boolean hasComparatorInputOverride(BlockState state) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (blockState.get(HAS_BOOK).booleanValue() && (tileentity = worldIn.getTileEntity(pos)) instanceof LecternTileEntity) {
            return ((LecternTileEntity)tileentity).getComparatorSignalLevel();
        }
        return 0;
    }

    @Override
    public ActionResultType onBlockActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (state.get(HAS_BOOK).booleanValue()) {
            if (!worldIn.isRemote) {
                this.openContainer(worldIn, pos, player);
            }
            return ActionResultType.func_233537_a_(worldIn.isRemote);
        }
        ItemStack itemstack = player.getHeldItem(handIn);
        return !itemstack.isEmpty() && !itemstack.getItem().isIn(ItemTags.LECTERN_BOOKS) ? ActionResultType.CONSUME : ActionResultType.PASS;
    }

    @Override
    @Nullable
    public INamedContainerProvider getContainer(BlockState state, World worldIn, BlockPos pos) {
        return state.get(HAS_BOOK) == false ? null : super.getContainer(state, worldIn, pos);
    }

    private void openContainer(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.getTileEntity(pos);
        if (tileentity instanceof LecternTileEntity) {
            player.openContainer((LecternTileEntity)tileentity);
            player.addStat(Stats.INTERACT_WITH_LECTERN);
        }
    }

    @Override
    public boolean allowsMovement(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

