/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.IRenderCall;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<IRenderCall> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final Tessellator RENDER_THREAD_TESSELATOR = new Tessellator();
    public static final float DEFAULTALPHACUTOFF = 0.1f;
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    private static Thread gameThread;
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean p_initGameThread_0_) {
        boolean flag;
        boolean bl = flag = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || flag == p_initGameThread_0_) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> p_assertThread_0_) {
        if (!p_assertThread_0_.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(IRenderCall p_recordRenderCall_0_) {
        recordingQueue.add(p_recordRenderCall_0_);
    }

    public static void flipFrame(long p_flipFrame_0_) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        Tessellator.getInstance().getBuffer().reset();
        GLFW.glfwSwapBuffers((long)p_flipFrame_0_);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            IRenderCall irendercall = recordingQueue.poll();
            irendercall.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int p_limitDisplayFPS_0_) {
        double d0 = lastDrawTime + 1.0 / (double)p_limitDisplayFPS_0_;
        double d1 = GLFW.glfwGetTime();
        while (d1 < d0) {
            GLFW.glfwWaitEventsTimeout((double)(d0 - d1));
            d1 = GLFW.glfwGetTime();
        }
        lastDrawTime = d1;
    }

    @Deprecated
    public static void pushLightingAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.pushLightingAttributes();
    }

    @Deprecated
    public static void pushTextureAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.pushTextureAttributes();
    }

    @Deprecated
    public static void popAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.popAttributes();
    }

    @Deprecated
    public static void disableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableAlphaTest();
    }

    @Deprecated
    public static void enableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableAlphaTest();
    }

    @Deprecated
    public static void alphaFunc(int p_alphaFunc_0_, float p_alphaFunc_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.alphaFunc(p_alphaFunc_0_, p_alphaFunc_1_);
    }

    @Deprecated
    public static void enableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableLighting();
    }

    @Deprecated
    public static void disableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableLighting();
    }

    @Deprecated
    public static void enableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableColorMaterial();
    }

    @Deprecated
    public static void disableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableColorMaterial();
    }

    @Deprecated
    public static void colorMaterial(int p_colorMaterial_0_, int p_colorMaterial_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.colorMaterial(p_colorMaterial_0_, p_colorMaterial_1_);
    }

    @Deprecated
    public static void normal3f(float p_normal3f_0_, float p_normal3f_1_, float p_normal3f_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.normal3f(p_normal3f_0_, p_normal3f_1_, p_normal3f_2_);
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.enableDepthTest();
    }

    public static void enableScissor(int p_enableScissor_0_, int p_enableScissor_1_, int p_enableScissor_2_, int p_enableScissor_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_244594_k();
        GlStateManager.func_244592_a(p_enableScissor_0_, p_enableScissor_1_, p_enableScissor_2_, p_enableScissor_3_);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.func_244593_j();
    }

    public static void depthFunc(int p_depthFunc_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.depthFunc(p_depthFunc_0_);
    }

    public static void depthMask(boolean p_depthMask_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.depthMask(p_depthMask_0_);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableBlend();
    }

    public static void blendFunc(GlStateManager.SourceFactor p_blendFunc_0_, GlStateManager.DestFactor p_blendFunc_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendFunc(p_blendFunc_0_.param, p_blendFunc_1_.param);
    }

    public static void blendFunc(int p_blendFunc_0_, int p_blendFunc_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendFunc(p_blendFunc_0_, p_blendFunc_1_);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor p_blendFuncSeparate_0_, GlStateManager.DestFactor p_blendFuncSeparate_1_, GlStateManager.SourceFactor p_blendFuncSeparate_2_, GlStateManager.DestFactor p_blendFuncSeparate_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendFuncSeparate(p_blendFuncSeparate_0_.param, p_blendFuncSeparate_1_.param, p_blendFuncSeparate_2_.param, p_blendFuncSeparate_3_.param);
    }

    public static void blendFuncSeparate(int p_blendFuncSeparate_0_, int p_blendFuncSeparate_1_, int p_blendFuncSeparate_2_, int p_blendFuncSeparate_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendFuncSeparate(p_blendFuncSeparate_0_, p_blendFuncSeparate_1_, p_blendFuncSeparate_2_, p_blendFuncSeparate_3_);
    }

    public static void blendEquation(int p_blendEquation_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendEquation(p_blendEquation_0_);
    }

    public static void blendColor(float p_blendColor_0_, float p_blendColor_1_, float p_blendColor_2_, float p_blendColor_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.blendColor(p_blendColor_0_, p_blendColor_1_, p_blendColor_2_, p_blendColor_3_);
    }

    @Deprecated
    public static void enableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableFog();
    }

    @Deprecated
    public static void disableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableFog();
    }

    @Deprecated
    public static void fogMode(GlStateManager.FogMode p_fogMode_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogMode(p_fogMode_0_.param);
    }

    @Deprecated
    public static void fogMode(int p_fogMode_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogMode(p_fogMode_0_);
    }

    @Deprecated
    public static void fogDensity(float p_fogDensity_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogDensity(p_fogDensity_0_);
    }

    @Deprecated
    public static void fogStart(float p_fogStart_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogStart(p_fogStart_0_);
    }

    @Deprecated
    public static void fogEnd(float p_fogEnd_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogEnd(p_fogEnd_0_);
    }

    @Deprecated
    public static void fog(int p_fog_0_, float p_fog_1_, float p_fog_2_, float p_fog_3_, float p_fog_4_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fog(p_fog_0_, new float[]{p_fog_1_, p_fog_2_, p_fog_3_, p_fog_4_});
    }

    @Deprecated
    public static void fogi(int p_fogi_0_, int p_fogi_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.fogi(p_fogi_0_, p_fogi_1_);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableCull();
    }

    public static void polygonMode(int p_polygonMode_0_, int p_polygonMode_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.polygonMode(p_polygonMode_0_, p_polygonMode_1_);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disablePolygonOffset();
    }

    public static void enableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableLineOffset();
    }

    public static void disableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableLineOffset();
    }

    public static void polygonOffset(float p_polygonOffset_0_, float p_polygonOffset_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.polygonOffset(p_polygonOffset_0_, p_polygonOffset_1_);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.LogicOp p_logicOp_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.logicOp(p_logicOp_0_.opcode);
    }

    public static void activeTexture(int p_activeTexture_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.activeTexture(p_activeTexture_0_);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableTexture();
    }

    public static void texParameter(int p_texParameter_0_, int p_texParameter_1_, int p_texParameter_2_) {
        GlStateManager.texParameter(p_texParameter_0_, p_texParameter_1_, p_texParameter_2_);
    }

    public static void deleteTexture(int p_deleteTexture_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.deleteTexture(p_deleteTexture_0_);
    }

    public static void bindTexture(int p_bindTexture_0_) {
        GlStateManager.bindTexture(p_bindTexture_0_);
    }

    @Deprecated
    public static void shadeModel(int p_shadeModel_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.shadeModel(p_shadeModel_0_);
    }

    @Deprecated
    public static void enableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.enableRescaleNormal();
    }

    @Deprecated
    public static void disableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.disableRescaleNormal();
    }

    public static void viewport(int p_viewport_0_, int p_viewport_1_, int p_viewport_2_, int p_viewport_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.viewport(p_viewport_0_, p_viewport_1_, p_viewport_2_, p_viewport_3_);
    }

    public static void colorMask(boolean p_colorMask_0_, boolean p_colorMask_1_, boolean p_colorMask_2_, boolean p_colorMask_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.colorMask(p_colorMask_0_, p_colorMask_1_, p_colorMask_2_, p_colorMask_3_);
    }

    public static void stencilFunc(int p_stencilFunc_0_, int p_stencilFunc_1_, int p_stencilFunc_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.stencilFunc(p_stencilFunc_0_, p_stencilFunc_1_, p_stencilFunc_2_);
    }

    public static void stencilMask(int p_stencilMask_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.stencilMask(p_stencilMask_0_);
    }

    public static void stencilOp(int p_stencilOp_0_, int p_stencilOp_1_, int p_stencilOp_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.stencilOp(p_stencilOp_0_, p_stencilOp_1_, p_stencilOp_2_);
    }

    public static void clearDepth(double p_clearDepth_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.clearDepth(p_clearDepth_0_);
    }

    public static void clearColor(float p_clearColor_0_, float p_clearColor_1_, float p_clearColor_2_, float p_clearColor_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.clearColor(p_clearColor_0_, p_clearColor_1_, p_clearColor_2_, p_clearColor_3_);
    }

    public static void clearStencil(int p_clearStencil_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.clearStencil(p_clearStencil_0_);
    }

    public static void clear(int p_clear_0_, boolean p_clear_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.clear(p_clear_0_, p_clear_1_);
    }

    @Deprecated
    public static void matrixMode(int p_matrixMode_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.matrixMode(p_matrixMode_0_);
    }

    @Deprecated
    public static void loadIdentity() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.loadIdentity();
    }

    @Deprecated
    public static void pushMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.pushMatrix();
    }

    @Deprecated
    public static void popMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.popMatrix();
    }

    @Deprecated
    public static void ortho(double p_ortho_0_, double p_ortho_2_, double p_ortho_4_, double p_ortho_6_, double p_ortho_8_, double p_ortho_10_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.ortho(p_ortho_0_, p_ortho_2_, p_ortho_4_, p_ortho_6_, p_ortho_8_, p_ortho_10_);
    }

    @Deprecated
    public static void rotatef(float p_rotatef_0_, float p_rotatef_1_, float p_rotatef_2_, float p_rotatef_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.rotatef(p_rotatef_0_, p_rotatef_1_, p_rotatef_2_, p_rotatef_3_);
    }

    @Deprecated
    public static void scalef(float p_scalef_0_, float p_scalef_1_, float p_scalef_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.scalef(p_scalef_0_, p_scalef_1_, p_scalef_2_);
    }

    @Deprecated
    public static void scaled(double p_scaled_0_, double p_scaled_2_, double p_scaled_4_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.scaled(p_scaled_0_, p_scaled_2_, p_scaled_4_);
    }

    @Deprecated
    public static void translatef(float p_translatef_0_, float p_translatef_1_, float p_translatef_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.translatef(p_translatef_0_, p_translatef_1_, p_translatef_2_);
    }

    @Deprecated
    public static void translated(double p_translated_0_, double p_translated_2_, double p_translated_4_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.translated(p_translated_0_, p_translated_2_, p_translated_4_);
    }

    @Deprecated
    public static void multMatrix(Matrix4f p_multMatrix_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.multMatrix(p_multMatrix_0_);
    }

    @Deprecated
    public static void color4f(float p_color4f_0_, float p_color4f_1_, float p_color4f_2_, float p_color4f_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.color4f(p_color4f_0_, p_color4f_1_, p_color4f_2_, p_color4f_3_);
    }

    @Deprecated
    public static void color3f(float p_color3f_0_, float p_color3f_1_, float p_color3f_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.color4f(p_color3f_0_, p_color3f_1_, p_color3f_2_, 1.0f);
    }

    @Deprecated
    public static void clearCurrentColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.clearCurrentColor();
    }

    public static void drawArrays(int p_drawArrays_0_, int p_drawArrays_1_, int p_drawArrays_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.drawArrays(p_drawArrays_0_, p_drawArrays_1_, p_drawArrays_2_);
    }

    public static void lineWidth(float p_lineWidth_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.lineWidth(p_lineWidth_0_);
    }

    public static void pixelStore(int p_pixelStore_0_, int p_pixelStore_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager.pixelStore(p_pixelStore_0_, p_pixelStore_1_);
    }

    public static void pixelTransfer(int p_pixelTransfer_0_, float p_pixelTransfer_1_) {
        GlStateManager.pixelTransfer(p_pixelTransfer_0_, p_pixelTransfer_1_);
    }

    public static void readPixels(int p_readPixels_0_, int p_readPixels_1_, int p_readPixels_2_, int p_readPixels_3_, int p_readPixels_4_, int p_readPixels_5_, ByteBuffer p_readPixels_6_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.readPixels(p_readPixels_0_, p_readPixels_1_, p_readPixels_2_, p_readPixels_3_, p_readPixels_4_, p_readPixels_5_, p_readPixels_6_);
    }

    public static void getString(int p_getString_0_, Consumer<String> p_getString_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        p_getString_1_.accept(GlStateManager.getString(p_getString_0_));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int p_initRenderer_0_, boolean p_initRenderer_1_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(p_initRenderer_0_, p_initRenderer_1_);
    }

    public static void setErrorCallback(GLFWErrorCallbackI p_setErrorCallback_0_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(p_setErrorCallback_0_);
    }

    public static void renderCrosshair(int p_renderCrosshair_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(p_renderCrosshair_0_, true, true, true);
    }

    public static void setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._setupNvFogDistance();
    }

    @Deprecated
    public static void glMultiTexCoord2f(int p_glMultiTexCoord2f_0_, float p_glMultiTexCoord2f_1_, float p_glMultiTexCoord2f_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.multiTexCoord2f(p_glMultiTexCoord2f_0_, p_glMultiTexCoord2f_1_, p_glMultiTexCoord2f_2_);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return GLX._getCapsString();
    }

    public static void setupDefaultState(int p_setupDefaultState_0_, int p_setupDefaultState_1_, int p_setupDefaultState_2_, int p_setupDefaultState_3_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GlStateManager.enableTexture();
        GlStateManager.shadeModel(7425);
        GlStateManager.clearDepth(1.0);
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc(515);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        GlStateManager.viewport(p_setupDefaultState_0_, p_setupDefaultState_1_, p_setupDefaultState_2_, p_setupDefaultState_3_);
    }

    public static int maxSupportedTextureSize() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            int i = GlStateManager.getInteger(3379);
            for (int j = Math.max(32768, i); j >= 1024; j >>= 1) {
                GlStateManager.texImage2D(32868, 0, 6408, j, j, 0, 6408, 5121, null);
                int k = GlStateManager.getTexLevelParameter(32868, 0, 4096);
                if (k == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = j;
                return j;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(i, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int p_glBindBuffer_0_, Supplier<Integer> p_glBindBuffer_1_) {
        GlStateManager.bindBuffer(p_glBindBuffer_0_, p_glBindBuffer_1_.get());
    }

    public static void glBufferData(int p_glBufferData_0_, ByteBuffer p_glBufferData_1_, int p_glBufferData_2_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.bufferData(p_glBufferData_0_, p_glBufferData_1_, p_glBufferData_2_);
    }

    public static void glDeleteBuffers(int p_glDeleteBuffers_0_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.deleteBuffers(p_glDeleteBuffers_0_);
    }

    public static void glUniform1i(int p_glUniform1i_0_, int p_glUniform1i_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform1i(p_glUniform1i_0_, p_glUniform1i_1_);
    }

    public static void glUniform1(int p_glUniform1_0_, IntBuffer p_glUniform1_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform1i(p_glUniform1_0_, p_glUniform1_1_);
    }

    public static void glUniform2(int p_glUniform2_0_, IntBuffer p_glUniform2_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform2i(p_glUniform2_0_, p_glUniform2_1_);
    }

    public static void glUniform3(int p_glUniform3_0_, IntBuffer p_glUniform3_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform3i(p_glUniform3_0_, p_glUniform3_1_);
    }

    public static void glUniform4(int p_glUniform4_0_, IntBuffer p_glUniform4_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform4i(p_glUniform4_0_, p_glUniform4_1_);
    }

    public static void glUniform1(int p_glUniform1_0_, FloatBuffer p_glUniform1_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform1f(p_glUniform1_0_, p_glUniform1_1_);
    }

    public static void glUniform2(int p_glUniform2_0_, FloatBuffer p_glUniform2_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform2f(p_glUniform2_0_, p_glUniform2_1_);
    }

    public static void glUniform3(int p_glUniform3_0_, FloatBuffer p_glUniform3_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform3f(p_glUniform3_0_, p_glUniform3_1_);
    }

    public static void glUniform4(int p_glUniform4_0_, FloatBuffer p_glUniform4_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniform4f(p_glUniform4_0_, p_glUniform4_1_);
    }

    public static void glUniformMatrix2(int p_glUniformMatrix2_0_, boolean p_glUniformMatrix2_1_, FloatBuffer p_glUniformMatrix2_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniformMatrix2f(p_glUniformMatrix2_0_, p_glUniformMatrix2_1_, p_glUniformMatrix2_2_);
    }

    public static void glUniformMatrix3(int p_glUniformMatrix3_0_, boolean p_glUniformMatrix3_1_, FloatBuffer p_glUniformMatrix3_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniformMatrix3f(p_glUniformMatrix3_0_, p_glUniformMatrix3_1_, p_glUniformMatrix3_2_);
    }

    public static void glUniformMatrix4(int p_glUniformMatrix4_0_, boolean p_glUniformMatrix4_1_, FloatBuffer p_glUniformMatrix4_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.uniformMatrix4f(p_glUniformMatrix4_0_, p_glUniformMatrix4_1_, p_glUniformMatrix4_2_);
    }

    public static void setupOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupOutline();
    }

    public static void teardownOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.teardownOutline();
    }

    public static void setupOverlayColor(IntSupplier p_setupOverlayColor_0_, int p_setupOverlayColor_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupOverlayColor(p_setupOverlayColor_0_.getAsInt(), p_setupOverlayColor_1_);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.teardownOverlayColor();
    }

    public static void setupLevelDiffuseLighting(Vector3f p_setupLevelDiffuseLighting_0_, Vector3f p_setupLevelDiffuseLighting_1_, Matrix4f p_setupLevelDiffuseLighting_2_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupLighting(p_setupLevelDiffuseLighting_0_, p_setupLevelDiffuseLighting_1_, p_setupLevelDiffuseLighting_2_);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f p_setupGuiFlatDiffuseLighting_0_, Vector3f p_setupGuiFlatDiffuseLighting_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupScaledLighting(p_setupGuiFlatDiffuseLighting_0_, p_setupGuiFlatDiffuseLighting_1_);
    }

    public static void setupGui3DDiffuseLighting(Vector3f p_setupGui3DDiffuseLighting_0_, Vector3f p_setupGui3DDiffuseLighting_1_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGui3DMatrix(p_setupGui3DDiffuseLighting_0_, p_setupGui3DDiffuseLighting_1_);
    }

    public static void mulTextureByProjModelView() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.mulTextureByProjModelView();
    }

    public static void setupEndPortalTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupEndPortalTexGen();
    }

    public static void clearTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.clearTexGen();
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> p_glGenBuffers_0_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> p_glGenBuffers_0_.accept(GlStateManager.genBuffers()));
        } else {
            p_glGenBuffers_0_.accept(GlStateManager.genBuffers());
        }
    }

    public static Tessellator renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    public static void defaultAlphaFunc() {
        RenderSystem.alphaFunc(516, 0.1f);
    }

    @Deprecated
    public static void runAsFancy(Runnable p_runAsFancy_0_) {
        boolean flag = Minecraft.isFabulousGraphicsEnabled();
        if (!flag) {
            p_runAsFancy_0_.run();
        } else {
            GameSettings gamesettings = Minecraft.getInstance().gameSettings;
            GraphicsFanciness graphicsfanciness = gamesettings.graphicFanciness;
            gamesettings.graphicFanciness = GraphicsFanciness.FANCY;
            p_runAsFancy_0_.run();
            gamesettings.graphicFanciness = graphicsfanciness;
        }
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
    }
}

