/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.system.math;

import com.mentalfrostbyte.jello.util.system.math.vector.Vector2d;
import java.util.ArrayList;
import java.util.List;

public class SmoothInterpolator {
    private final double smoothnessFactor;

    public SmoothInterpolator(double smoothnessFactor) {
        if (smoothnessFactor <= 0.0 || smoothnessFactor >= 1.0) {
            throw new AssertionError((Object)"Smoothness must be between 0 and 1 (both non-inclusive)");
        }
        this.smoothnessFactor = smoothnessFactor;
    }

    public static float interpolate(float t, double ... points) {
        ArrayList<Vector2d> vectorPoints = new ArrayList<Vector2d>();
        vectorPoints.add(new Vector2d(0.0, 0.0));
        vectorPoints.add(new Vector2d(points[0], points[1]));
        vectorPoints.add(new Vector2d(points[2], points[3]));
        vectorPoints.add(new Vector2d(1.0, 1.0));
        SmoothInterpolator smoothInterpolator = new SmoothInterpolator(0.0055555556900799274);
        return (float)smoothInterpolator.calculateInterpolatedValue(vectorPoints, t);
    }

    public Vector2d calculateQuadraticInterpolation(Vector2d p0, Vector2d p1, Vector2d p2, double t) {
        double oneMinusT = 1.0 - t;
        double oneMinusTSquared = oneMinusT * oneMinusT;
        double x = oneMinusTSquared * p0.x() + 2.0 * t * oneMinusT * p1.x() + t * t * p2.x();
        double y = oneMinusTSquared * p0.y() + 2.0 * t * oneMinusT * p1.y() + t * t * p2.y();
        return new Vector2d(x, y);
    }

    public Vector2d calculateCubicInterpolation(Vector2d p0, Vector2d p1, Vector2d p2, Vector2d p3, double t) {
        double oneMinusT = 1.0 - t;
        double oneMinusTSquared = oneMinusT * oneMinusT;
        double oneMinusTCubed = oneMinusTSquared * oneMinusT;
        double x = p0.x() * oneMinusTCubed + p1.x() * 3.0 * t * oneMinusTSquared + p2.x() * 3.0 * t * t * oneMinusT + p3.x() * t * t * t;
        double y = p0.y() * oneMinusTCubed + p1.y() * 3.0 * t * oneMinusTSquared + p2.y() * 3.0 * t * t * oneMinusT + p3.y() * t * t * t;
        return new Vector2d(x, y);
    }

    public double calculateInterpolatedValue(List<Vector2d> points, float t) {
        Vector2d currentPoint;
        if (t == 0.0f) {
            return 0.0;
        }
        List<Vector2d> processedPoints = this.generateInterpolatedPoints(points);
        double result = 1.0;
        for (int i = 0; i < processedPoints.size() && (currentPoint = processedPoints.get(i)).x() <= (double)t; ++i) {
            result = currentPoint.y();
            Vector2d nextPoint = new Vector2d(1.0, 1.0);
            if (i + 1 < processedPoints.size()) {
                nextPoint = processedPoints.get(i + 1);
            }
            double deltaX = nextPoint.x() - currentPoint.x();
            double deltaY = nextPoint.y() - currentPoint.y();
            double deltaT = (double)t - currentPoint.x();
            double ratio = deltaT / deltaX;
            result += deltaY * ratio;
        }
        return result;
    }

    public List<Vector2d> generateInterpolatedPoints(List<Vector2d> controlPoints) {
        if (controlPoints != null) {
            if (controlPoints.size() >= 3) {
                Vector2d p0 = controlPoints.get(0);
                Vector2d p1 = controlPoints.get(1);
                Vector2d p2 = controlPoints.get(2);
                Vector2d p3 = controlPoints.size() != 4 ? null : controlPoints.get(3);
                ArrayList<Vector2d> interpolatedPoints = new ArrayList<Vector2d>();
                Vector2d currentPoint = p0;
                for (double t = 0.0; t < 1.0; t += this.smoothnessFactor) {
                    interpolatedPoints.add(currentPoint);
                    currentPoint = p3 != null ? this.calculateCubicInterpolation(p0, p1, p2, p3, t) : this.calculateQuadraticInterpolation(p0, p1, p2, t);
                }
                return interpolatedPoints;
            }
            return null;
        }
        throw new AssertionError((Object)"Provided list had no reference");
    }
}

