/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.system;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mentalfrostbyte.Client;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static boolean freshConfig = false;

    public static void save(JsonObject var0, File var1) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)var0);
        try (FileOutputStream var4 = new FileOutputStream(var1);){
            IOUtils.write((String)json, (OutputStream)var4, (String)"UTF-8");
        }
    }

    public static JsonObject readFile(File var0) throws IOException {
        JsonObject var3 = new JsonObject();
        if (var0.exists()) {
            try (FileInputStream var4 = new FileInputStream(var0);){
                String var5 = IOUtils.toString((InputStream)var4, (String)"UTF-8");
                if (var5 != null && !var5.isEmpty()) {
                    try {
                        var3 = JsonParser.parseString((String)var5).getAsJsonObject();
                    }
                    catch (JsonParseException var7) {
                        Client.logger.warn("Error when reading json from config. Continuing, but no preferences will be loaded.", (Throwable)var7);
                    }
                }
                Client.logger.warn("Empty config file");
            }
        } else {
            Client.logger.info("Config does not exist... creating new config file...");
            freshConfig = true;
            var0.createNewFile();
        }
        return var3;
    }

    public static File getFileFromDialog() {
        FileDialog fileDialog = new FileDialog((Frame)null, "Select a .txt file");
        fileDialog.setMode(0);
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        fileDialog.setAlwaysOnTop(true);
        String fileName = fileDialog.getFile();
        if (fileName == null) {
            return null;
        }
        return new File(fileDialog.getDirectory(), fileName);
    }
}

