/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.sound;

import com.mentalfrostbyte.jello.util.game.sound.Class8084;
import com.mentalfrostbyte.jello.util.game.sound.Class8255;
import com.mentalfrostbyte.jello.util.game.sound.Class9616;
import com.mentalfrostbyte.jello.util.game.sound.Class9705;
import com.mentalfrostbyte.jello.util.game.sound.NBSFile;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NBSFileReader {
    public static NBSFile fromFile(File file) {
        try {
            return NBSFileReader.read(new FileInputStream(file), file);
        }
        catch (FileNotFoundException var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static NBSFile fromInputStream(InputStream inputStream) {
        return NBSFileReader.read(inputStream, null);
    }

    private static NBSFile read(InputStream inputStream, File file) {
        HashMap<Integer, Class9616> var4 = new HashMap<Integer, Class9616>();
        try {
            DataInputStream stream = new DataInputStream(inputStream);
            short var25 = NBSFileReader.readSigned16(stream);
            byte var8 = 10;
            byte var9 = 0;
            if (var25 == 0) {
                var9 = stream.readByte();
                var8 = stream.readByte();
                if (var9 >= 3) {
                    var25 = NBSFileReader.readSigned16(stream);
                }
            }
            int var10 = Class9705.maxId() - var8;
            short s = NBSFileReader.readSigned16(stream);
            String author = NBSFileReader.readString(stream);
            String name = NBSFileReader.readString(stream);
            NBSFileReader.readString(stream);
            String var14 = NBSFileReader.readString(stream);
            float var15 = (float)NBSFileReader.readSigned16(stream) / 100.0f;
            stream.readBoolean();
            stream.readByte();
            stream.readByte();
            NBSFileReader.readUnsignedI(stream);
            NBSFileReader.readUnsignedI(stream);
            NBSFileReader.readUnsignedI(stream);
            NBSFileReader.readUnsignedI(stream);
            NBSFileReader.readUnsignedI(stream);
            NBSFileReader.readString(stream);
            short var16 = -1;
            block4: while (true) {
                short var17;
                if ((var17 = NBSFileReader.readSigned16(stream)) == 0) {
                    if (var9 > 0 && var9 < 3) {
                        var25 = var16;
                    }
                    for (int var26 = 0; var26 < s; ++var26) {
                        Class9616 var28 = (Class9616)var4.get(var26);
                        String var30 = NBSFileReader.readString(stream);
                        byte var33 = stream.readByte();
                        if (var9 >= 2) {
                            stream.readByte();
                        }
                        if (var28 == null) continue;
                        var28.method37432(var30);
                        var28.method37436(var33);
                    }
                    int var27 = stream.readByte();
                    Class8084[] var29 = new Class8084[var27];
                    for (int var31 = 0; var31 < var27; ++var31) {
                        var29[var31] = new Class8084((byte)var31, NBSFileReader.readString(stream), NBSFileReader.readString(stream));
                        stream.readByte();
                        stream.readByte();
                    }
                    if (var10 < 0) {
                        ArrayList<Class8084> var32 = Class7179.method22534();
                        var32.addAll(Arrays.asList(var29));
                        var29 = var32.toArray(var29);
                    } else {
                        var8 += var10;
                    }
                    NBSFile result = new NBSFile(var15, var4, s, var25, author, name, var14, file, var8, var29);
                    return result;
                }
                var16 = (short)(var16 + var17);
                int var18 = -1;
                while (true) {
                    short var19;
                    if ((var19 = NBSFileReader.readSigned16(stream)) == 0) continue block4;
                    var18 = (short)(var18 + var19);
                    byte var20 = stream.readByte();
                    if (var10 > 0 && var20 >= var8) {
                        var20 = (byte)(var20 + var10);
                    }
                    NBSFileReader.method29872(var18, var16, var20, stream.readByte(), var4);
                }
                break;
            }
        }
        catch (FileNotFoundException var21) {
            var21.printStackTrace();
        }
        catch (EOFException var22) {
            String var7 = "";
            if (file != null) {
                var7 = file.getName();
            }
        }
        catch (IOException var23) {
            var23.printStackTrace();
        }
        return null;
    }

    private static void method29872(int var0, int var1, byte var2, byte var3, HashMap<Integer, Class9616> var4) {
        Class9616 var7 = var4.get(var0);
        if (var7 == null) {
            var7 = new Class9616();
            var4.put(var0, var7);
        }
        var7.method37434(var1, new Class8255(var2, var3));
    }

    private static short readSigned16(DataInputStream stream) throws IOException {
        int a = stream.readUnsignedByte();
        int b = stream.readUnsignedByte();
        return (short)(a + (b << 8));
    }

    private static int readUnsignedI(DataInputStream stream) throws IOException {
        int var3 = stream.readUnsignedByte();
        int var4 = stream.readUnsignedByte();
        int var5 = stream.readUnsignedByte();
        int var6 = stream.readUnsignedByte();
        return var3 + (var4 << 8) + (var5 << 16) + (var6 << 24);
    }

    private static String readString(DataInputStream stream) throws IOException {
        int var3;
        StringBuilder var4 = new StringBuilder(var3);
        for (var3 = NBSFileReader.readUnsignedI(stream); var3 > 0; --var3) {
            char var5 = (char)stream.readByte();
            if (var5 == '\r') {
                var5 = ' ';
            }
            var4.append(var5);
        }
        return var4.toString();
    }

    public static class Class7179 {
        public static ArrayList<Class8084> method22534() {
            ArrayList<Class8084> var3 = new ArrayList<Class8084>();
            var3.add(new Class8084(0, "Iron Xylophone", "iron_xylophone.ogg"));
            var3.add(new Class8084(0, "Cow Bell", "cow_bell.ogg"));
            var3.add(new Class8084(0, "Didgeridoo", "didgeridoo.ogg"));
            var3.add(new Class8084(0, "Bit", "bit.ogg"));
            var3.add(new Class8084(0, "Banjo", "banjo.ogg"));
            var3.add(new Class8084(0, "Pling", "pling.ogg"));
            return var3;
        }
    }
}

