/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.player.rotation;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.util.game.player.rotation.NeuralNetwork;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TrainingManager {
    private static final int MAX_SAMPLES = 1000;
    private static final int BATCH_SIZE = 12;
    private Queue<TrainingSample> trainingSamples = new ConcurrentLinkedQueue<TrainingSample>();
    private Thread trainingThread;
    private boolean trainingThreadRunning = false;
    private static final String TRAINING_FILE = "jelloai_training.dat";
    private final NeuralNetwork neuralNetwork;

    public TrainingManager(NeuralNetwork sharedNetwork) {
        this.neuralNetwork = sharedNetwork;
    }

    public TrainingManager() {
        this.neuralNetwork = new NeuralNetwork();
    }

    public void initialize() {
        this.deleteTrainingDataFile();
        this.loadTrainingData();
    }

    private void deleteTrainingDataFile() {
        try {
            File file = new File(Client.getInstance().file, TRAINING_FILE);
            if (file.exists()) {
                boolean deleted = file.delete();
                if (deleted) {
                    Client.logger.info("JelloAI: Deleted old training data file");
                } else {
                    Client.logger.warn("JelloAI: Failed to delete old training data file");
                }
            }
        }
        catch (Exception e) {
            Client.logger.error("Error deleting JelloAI training data file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrainingSample(float[] inputs, float[] expected, float weight) {
        if (inputs.length != 8 || expected.length != 2) {
            return;
        }
        Queue<TrainingSample> queue = this.trainingSamples;
        synchronized (queue) {
            if (this.trainingSamples.size() >= 1000) {
                this.trainingSamples.poll();
            }
            this.trainingSamples.add(new TrainingSample(inputs, expected, weight));
        }
        if (this.trainingSamples.size() >= 12) {
            this.trainNetwork();
        }
    }

    private void trainNetwork() {
        TrainingSample[] samples;
        if (this.trainingSamples.isEmpty()) {
            return;
        }
        for (TrainingSample sample : samples = this.trainingSamples.toArray(new TrainingSample[0])) {
            this.neuralNetwork.trainNetworkImmediate(sample.getInputs(), sample.getExpectedOutputs(), sample.getWeight());
        }
        this.trainingSamples.clear();
    }

    public void startTrainingThread() {
        if (this.trainingThreadRunning) {
            return;
        }
        this.trainingThreadRunning = true;
        this.trainingThread = new Thread(() -> {
            while (this.trainingThreadRunning) {
                try {
                    this.trainNetwork();
                    this.neuralNetwork.saveWeights();
                    this.saveTrainingData();
                    Thread.sleep(30000L);
                }
                catch (Exception e) {
                    Client.logger.error("Error in JelloAI training thread", (Throwable)e);
                }
            }
        });
        this.trainingThread.setDaemon(true);
        this.trainingThread.start();
    }

    public void stopTrainingThread() {
        this.trainingThreadRunning = false;
        if (this.trainingThread != null) {
            this.trainingThread.interrupt();
        }
    }

    private void saveTrainingData() {
        try {
            File file = new File(Client.getInstance().file, TRAINING_FILE);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            TrainingSample[] samples = this.trainingSamples.toArray(new TrainingSample[0]);
            out.writeObject(samples);
            out.close();
        }
        catch (Exception e) {
            Client.logger.error("Error saving JelloAI training data", (Throwable)e);
        }
    }

    private void loadTrainingData() {
        try {
            TrainingSample[] samples;
            File file = new File(Client.getInstance().file, TRAINING_FILE);
            if (!file.exists()) {
                return;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            for (TrainingSample sample : samples = (TrainingSample[])in.readObject()) {
                this.trainingSamples.add(sample);
            }
            in.close();
        }
        catch (Exception e) {
            Client.logger.error("Error loading JelloAI training data", (Throwable)e);
        }
    }

    public static class TrainingSample
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float[] inputs;
        private float[] expected;
        private float weight;

        public TrainingSample(float[] inputs, float[] expected, float weight) {
            this.inputs = inputs;
            this.expected = expected;
            this.weight = weight;
        }

        public float[] getInputs() {
            return this.inputs;
        }

        public float[] getExpectedOutputs() {
            return this.expected;
        }

        public float getWeight() {
            return this.weight;
        }
    }
}

