/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.util.system.other.SimpleEntryPair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class PlayerUtil {
    public static final float[] field24951 = new float[4];
    public static final float[] field24952 = new float[4];

    public static Vector3d getBoundingBoxCenter(AxisAlignedBB var0) {
        double var3 = var0.getCenter().x;
        double var5 = var0.minY;
        double var7 = var0.getCenter().z;
        double var9 = (var0.maxY - var5) * 0.95;
        double var11 = (var0.maxX - var0.minX) * 0.95;
        double var13 = (var0.maxZ - var0.minZ) * 0.95;
        double var15 = Math.max(var5, Math.min(var5 + var9, Module.mc.player.getPosY() + (double)Module.mc.player.getEyeHeight()));
        double var17 = Math.max(var3 - var11 / 2.0, Math.min(var3 + var11 / 2.0, Module.mc.player.getPosX()));
        double var19 = Math.max(var7 - var13 / 2.0, Math.min(var7 + var13 / 2.0, Module.mc.player.getPosZ()));
        return new Vector3d(var17, var15, var19);
    }

    public static List<String> getMobOwners(String uuid) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        String apiUrl = "https://api.ashcon.app/mojang/v2/user/" + uuid;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            ArrayList<String> arrayList;
            block20: {
                JsonObject json;
                CloseableHttpResponse response;
                block18: {
                    ArrayList<String> arrayList2;
                    block19: {
                        block16: {
                            ArrayList<String> arrayList3;
                            block17: {
                                HttpGet request = new HttpGet(apiUrl);
                                response = httpClient.execute((HttpUriRequest)request);
                                try {
                                    int statusCode = response.getStatusLine().getStatusCode();
                                    if (statusCode != 404) break block16;
                                    names.add("Unknown owner");
                                    arrayList3 = names;
                                    if (response == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (response != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                response.close();
                            }
                            return arrayList3;
                        }
                        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        json = JsonParser.parseString((String)responseBody).getAsJsonObject();
                        if (json.has("username")) break block18;
                        names.add("Unknown owner");
                        arrayList2 = names;
                        if (response == null) break block19;
                        response.close();
                    }
                    return arrayList2;
                }
                String username = json.get("username").getAsString();
                names.add(username);
                arrayList = names;
                if (response == null) break block20;
                response.close();
            }
            return arrayList;
        }
    }

    public static List<Entity> getEntitesInWorld() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Module.mc.world.entitiesById.forEach((entity1, entity2) -> entities.add((Entity)entity2));
        return entities;
    }

    public static SimpleEntryPair<Direction, Vector3d> findCollisionDirection(double var0) {
        Direction[] directions;
        AxisAlignedBB playerBoundBox = Module.mc.player.getBoundingBox();
        for (Direction direction : directions = new Direction[]{Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH}) {
            Iterator collisionShapes = Module.mc.world.getCollisionShapes(Module.mc.player, playerBoundBox.expand(var0 * (double)direction.getXOffset(), 0.0, var0 * (double)direction.getZOffset())).iterator();
            if (!collisionShapes.hasNext()) continue;
            Vector3d position = Module.mc.player.getPositionVec().add(Module.mc.player.getAllowedMovement(new Vector3d(direction.getXOffset(), 0.0, direction.getZOffset())));
            return new SimpleEntryPair<Direction, Vector3d>(direction, position);
        }
        return null;
    }

    public static boolean isCollidingWithSurroundingBlocks() {
        double buffer = 1.0E-7;
        return Module.mc.world.getCollisionShapes(Module.mc.player, Module.mc.player.getBoundingBox().expand(buffer, 0.0, buffer).expand(-buffer, 0.0, -buffer)).findAny().isPresent();
    }

    public static List<Entity> getAllEntitiesInWorld() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Module.mc.world.entitiesById.forEach((id, entity) -> entities.add((Entity)entity));
        return entities;
    }

    public static EntityTypeCategory getEntityCategory(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (!(entity instanceof PlayerEntity)) {
                return !(entity instanceof MobEntity) && !(entity instanceof MonsterEntity) && !(entity instanceof SlimeEntity) && !(entity instanceof FlyingEntity) ? EntityTypeCategory.NON_PLAYER : EntityTypeCategory.MONSTER;
            }
            return EntityTypeCategory.PLAYER;
        }
        return EntityTypeCategory.AIRBORNE;
    }

    public static double getDistanceTo(Vector3d position) {
        double deltaX = Module.mc.player.getPosX() - position.x;
        double deltaY = Module.mc.player.getPosY() + (double)Module.mc.player.getEyeHeight() - position.y;
        double deltaZ = Module.mc.player.getPosZ() - position.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistanceToBoundingBox(AxisAlignedBB boundingBox) {
        Vector3d position = PlayerUtil.getBoundingBoxCenter(boundingBox);
        return PlayerUtil.getDistanceTo(position);
    }

    public static boolean isPlayerInCollision() {
        AxisAlignedBB playerBox = Module.mc.player.getBoundingBox().offset(0.0, -1.0, 0.0);
        if (Module.mc.player.getRidingEntity() != null) {
            double deltaX = Module.mc.player.getRidingEntity().prevPosX - Module.mc.player.getRidingEntity().getPosX();
            double deltaZ = Module.mc.player.getRidingEntity().prevPosZ - Module.mc.player.getRidingEntity().getPosZ();
            playerBox = Module.mc.player.getRidingEntity().getBoundingBox().expand(Math.abs(deltaX), 1.0, Math.abs(deltaZ));
        }
        Stream<VoxelShape> collisionShapes = Module.mc.world.getCollisionShapes(Module.mc.player, playerBox);
        return collisionShapes.findAny().isPresent();
    }

    public static boolean inLiquid(Entity entity) {
        ClientWorld world = Module.mc.world;
        AxisAlignedBB boundingBox = entity.getBoundingBox();
        return world.containsAnyLiquid(boundingBox);
    }

    public static boolean isEntityAboveGround(Entity entity) {
        if (!(entity.getPosY() < 1.0)) {
            if (!entity.isOnGround()) {
                AxisAlignedBB entityBoundingBox = entity.getBoundingBox();
                return Module.mc.world.getCollisionShapes(Module.mc.player, entityBoundingBox = entityBoundingBox.expand(0.0, -entity.getPosY(), 0.0)).count() == 0L;
            }
            return false;
        }
        return true;
    }

    public static enum EntityTypeCategory {
        MONSTER,
        PLAYER,
        NON_PLAYER,
        AIRBORNE;

    }
}

