/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.player;

import com.mentalfrostbyte.jello.gui.base.JelloPortal;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.util.game.world.blocks.BlockUtil;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.SandBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.AirItem;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.CompassItem;
import net.minecraft.item.EggItem;
import net.minecraft.item.EnderPearlItem;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SnowballItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;

public class InvManagerUtil {
    public static boolean isSlotEmpty(int slotIndex) {
        ItemStack itemStack = Module.mc.player.container.getSlot(slotIndex).getStack();
        return itemStack == null || itemStack.getItem() instanceof AirItem;
    }

    public static float getItemUseMultiplier(ItemStack itemStack) {
        if (itemStack == null) {
            return -1.0f;
        }
        Item item = itemStack.getItem();
        if (item instanceof SwordItem) {
            return 2.0f;
        }
        if (item instanceof BucketItem || item instanceof CompassItem || item instanceof ToolItem || item instanceof BowItem) {
            return 1.5f;
        }
        if (item instanceof PotionItem || item instanceof BlockItem) {
            return 1.0f;
        }
        if (itemStack.isFood()) {
            if (item.getFood() == Foods.GOLDEN_APPLE) {
                return 1.0f;
            }
            return 0.5f;
        }
        if (item instanceof EnderPearlItem) {
            return 1.0f;
        }
        if (item instanceof EggItem || item instanceof SnowballItem) {
            return 0.25f;
        }
        return 0.0f;
    }

    public static HashMap<Integer, Float> getItemUseMultipliers() {
        HashMap<Integer, Float> multipliers = new HashMap<Integer, Float>();
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            ItemStack itemStack = Module.mc.player.inventory.getStackInSlot(slotIndex);
            float multiplier = InvManagerUtil.getItemUseMultiplier(itemStack) * (float)(Module.mc.player.inventory.currentItem != slotIndex ? 1 : 2);
            multipliers.put(slotIndex, Float.valueOf(multiplier));
        }
        return multipliers;
    }

    public static int getSlotWithHighestItemUseMultiplier() {
        HashMap<Integer, Float> itemMultipliers = InvManagerUtil.getItemUseMultipliers();
        TreeMap sortedMultipliers = new TreeMap(Collections.reverseOrder());
        sortedMultipliers.putAll(itemMultipliers);
        Map.Entry bestSlot = null;
        for (Map.Entry entry : sortedMultipliers.entrySet()) {
            if (bestSlot != null && !(((Float)bestSlot.getValue()).floatValue() > ((Float)entry.getValue()).floatValue())) continue;
            bestSlot = entry;
        }
        return (Integer)bestSlot.getKey();
    }

    public static int swapToolToHotbar(int var0) {
        int var3 = InvManagerUtil.getSlotWithHighestItemUseMultiplier();
        InvManagerUtil.clickSlot(Module.mc.player.container.windowId, var0, var3, ClickType.SWAP, Module.mc.player);
        return var3;
    }

    public static int findItemInContainer(Item ... items) {
        int highestCount = 0;
        int bestSlot = -1;
        for (int slotIndex = 44; slotIndex >= 9; --slotIndex) {
            ItemStack itemStack = Module.mc.player.container.getSlot(slotIndex).getStack();
            if (InvManagerUtil.isSlotEmpty(slotIndex)) continue;
            for (Item item : items) {
                int itemCount;
                if (itemStack.getItem() != item || (itemCount = itemStack.getCount()) <= highestCount) continue;
                bestSlot = slotIndex;
                highestCount = itemCount;
            }
        }
        return bestSlot;
    }

    public static void clickSlot(int slot) {
        Module.mc.playerController.windowClick(Module.mc.player.container.windowId, slot, 1, ClickType.THROW, Module.mc.player);
    }

    public static boolean isPotionItem(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem() instanceof PotionItem;
    }

    public static ItemStack getItemInSlot(int slotIndex) {
        return Module.mc.player.container.getSlot(slotIndex).getStack();
    }

    public static int isHotbarEmpty() {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            ItemStack itemStack = Module.mc.player.inventory.getStackInSlot(hotbarSlot);
            if (itemStack != null) continue;
            return hotbarSlot;
        }
        return 0;
    }

    public static int findBestToolFromHotbarSlotForBlock(BlockState state) {
        int slot = -1;
        float dmg = 1.0f;
        for (int hotbarSlot = 44; hotbarSlot >= 9; --hotbarSlot) {
            float damage;
            ItemStack item = Module.mc.player.container.getSlot(hotbarSlot).getStack();
            if (item == null) continue;
            if (state == null) {
                if (!(item.getItem() instanceof SwordItem)) continue;
                damage = ((SwordItem)item.getItem()).getAttackDamage();
            } else {
                damage = item.getDestroySpeed(state);
            }
            if (!(damage > dmg)) continue;
            slot = hotbarSlot;
            dmg = damage;
        }
        return slot;
    }

    public static int getSlotWithMaxItemCount(Item ... items) {
        int maxCount = 0;
        int maxCountSlot = -1;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            ItemStack stackInSlot = Module.mc.player.inventory.getStackInSlot(slotIndex);
            if (stackInSlot == null) continue;
            for (Item item : items) {
                int itemCount;
                if (stackInSlot.getItem() != item || (itemCount = stackInSlot.getCount()) <= maxCount) continue;
                maxCountSlot = slotIndex;
                maxCount = itemCount;
            }
        }
        return maxCountSlot;
    }

    public static int findItemSlot(Item var0) {
        int var3 = 0;
        int var4 = -1;
        for (int var5 = 44; var5 >= 9; --var5) {
            int var7;
            ItemStack var6 = Module.mc.player.container.getSlot(var5).getStack();
            if (InvManagerUtil.isSlotEmpty(var5) || var6.getItem() != var0 || (var7 = var6.getCount()) <= var3) continue;
            var4 = var5;
            var3 = var7;
        }
        return var4;
    }

    public static int getArmorProtectionValue(ItemStack itemStack) {
        if (itemStack != null) {
            return itemStack.getItem() instanceof ArmorItem ? ((ArmorItem)itemStack.getItem()).getDamageReduceAmount() + EnchantmentHelper.getEnchantmentLevel(Enchantments.PROTECTION, itemStack) : 0;
        }
        return 0;
    }

    public static int getTotalArmorProtection(PlayerEntity player) {
        int totalProtection = 0;
        for (int slot = 5; slot <= 8; ++slot) {
            totalProtection += InvManagerUtil.getArmorProtectionValue(player.inventory.getStackInSlot(slot));
        }
        return totalProtection;
    }

    public static boolean hasAllSlotsFilled() {
        for (Slot slot : Module.mc.player.container.inventorySlots) {
            if (slot.getHasStack() || slot.slotNumber <= 8 || slot.slotNumber >= 45) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemStackValid(ItemStack var0) {
        return var0 != null && !var0.getItem().equals(Items.AIR);
    }

    public static List<EffectInstance> getPotionEffects(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return itemStack.getItem() instanceof PotionItem ? PotionUtils.getEffectsFromStack(itemStack) : null;
    }

    public static boolean hasNegativePotionEffects(ItemStack itemStack) {
        if (itemStack != null && itemStack.getItem() instanceof PotionItem) {
            for (EffectInstance effect : InvManagerUtil.getPotionEffects(itemStack)) {
                if (effect.getPotion() != Effects.POISON && effect.getPotion() != Effects.INSTANT_DAMAGE && effect.getPotion() != Effects.SLOWNESS && effect.getPotion() != Effects.WEAKNESS) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack clickSlot(int windowId, int slotId, int usedButton, ClickType mode, PlayerEntity entity) {
        return InvManagerUtil.clickSlot(windowId, slotId, usedButton, mode, entity, false);
    }

    public static ItemStack clickSlot(int windowId, int slotId, int usedButton, ClickType mode, PlayerEntity entity, boolean fixed) {
        ItemStack clickedItem = null;
        if (slotId >= 0) {
            clickedItem = entity.openContainer.getSlot(slotId).getStack().copy();
        }
        short actionNumber = entity.openContainer.getNextTransactionID(Module.mc.player.inventory);
        ItemStack item = entity.openContainer.slotClick(slotId, usedButton, mode, entity);
        if (mode == null) {
            return item;
        }
        if (clickedItem == null || JelloPortal.getVersion().newerThan(ProtocolVersion.v1_12) && !fixed || mode == ClickType.SWAP) {
            clickedItem = item;
        }
        Module.mc.getConnection().sendPacket(new CClickWindowPacket(windowId, slotId, usedButton, mode, clickedItem, actionNumber));
        return item;
    }

    public static void clickSlot(int slot, int mouseButton) {
        Module.mc.playerController.windowClick(Module.mc.player.container.windowId, slot, mouseButton, ClickType.SWAP, Module.mc.player);
    }

    public static boolean isBestArmorPiece(ItemStack stack) {
        if (stack != null && stack.getItem() instanceof ArmorItem) {
            float prot = InvManagerUtil.getArmorProtectionValue(stack);
            for (int var4 = 5; var4 < 45; ++var4) {
                ItemStack st;
                Item i;
                if (!Module.mc.player.container.getSlot(var4).getHasStack() || !((i = (st = Module.mc.player.container.getSlot(var4).getStack()).getItem()) instanceof ArmorItem)) continue;
                ArmorItem it = (ArmorItem)i;
                float armorProtection = InvManagerUtil.getArmorProtectionValue(st);
                if (!(armorProtection > prot) || it.getEquipmentSlot() != ((ArmorItem)stack.getItem()).getEquipmentSlot()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isArmor(int slot) {
        return InvManagerUtil.isArmorStrongerThanSlot(Module.mc.player.container.getSlot(slot).getStack());
    }

    public static boolean isHead(ArmorItem armorPiece) {
        return armorPiece.getEquipmentSlot() == EquipmentSlotType.HEAD;
    }

    public static boolean isChestplate(ArmorItem armorPiece) {
        return armorPiece.getEquipmentSlot() == EquipmentSlotType.CHEST;
    }

    public static boolean isLeggings(ArmorItem armorPiece) {
        return armorPiece.getEquipmentSlot() == EquipmentSlotType.LEGS;
    }

    public static boolean isBoots(ArmorItem armorPiece) {
        return armorPiece.getEquipmentSlot() == EquipmentSlotType.FEET;
    }

    public static int getDamageReduceFromSlot(int slot) {
        ItemStack stack = Module.mc.player.container.getSlot(slot).getStack();
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem item2 = (ArmorItem)item;
            Enchantment en = Objects.requireNonNull(Enchantment.getEnchantmentByID(0));
            return item2.getDamageReduceAmount() + EnchantmentHelper.getEnchantmentLevel(en, stack);
        }
        return 0;
    }

    public static boolean isArmorStrongerThanSlot(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            int protectionValue = InvManagerUtil.getArmorProtectionValue(itemStack);
            if (!InvManagerUtil.isHead(armorItem)) {
                if (!InvManagerUtil.isChestplate(armorItem)) {
                    if (!InvManagerUtil.isLeggings(armorItem)) {
                        return InvManagerUtil.isBoots(armorItem) && protectionValue > InvManagerUtil.getDamageReduceFromSlot(8);
                    }
                    return protectionValue > InvManagerUtil.getDamageReduceFromSlot(7);
                }
                return protectionValue > InvManagerUtil.getDamageReduceFromSlot(6);
            }
            return protectionValue > InvManagerUtil.getDamageReduceFromSlot(5);
        }
        return false;
    }

    public static void clickSlot(int slotId, int mouseButton, boolean type) {
        Module.mc.playerController.windowClick(Module.mc.player.container.windowId, slotId, mouseButton, !type ? ClickType.THROW : ClickType.QUICK_MOVE, Module.mc.player);
    }

    public static boolean shouldPlaceItem(Item item) {
        if (!(item instanceof BlockItem)) {
            return false;
        }
        Block var3 = ((BlockItem)item).getBlock();
        return !BlockUtil.blocksToNotPlace.contains(var3) && !(var3 instanceof AbstractButtonBlock) && !(var3 instanceof BushBlock) && !(var3 instanceof TrapDoorBlock) && !(var3 instanceof AbstractPressurePlateBlock) && !(var3 instanceof SandBlock) && !(var3 instanceof OreBlock) && !(var3 instanceof SkullBlock) && !(var3 instanceof BedBlock) && !(var3 instanceof BannerBlock) && !(var3 instanceof ChestBlock) && !(var3 instanceof DoorBlock);
    }
}

