/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.client.render.classicgui;

import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.module.impl.gui.classic.TabGUI;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.system.math.MathHelper;
import org.newdawn.slick.TrueTypeFont;

public class CategoryDrawPartBackground {
    public final TrueTypeFont font;
    public final int priority;
    private boolean expanded = false;
    public Animation animation = new Animation(300, 300);

    public CategoryDrawPartBackground(int priority) {
        this.font = Resources.bold16;
        this.priority = priority;
    }

    public int getWidth() {
        return 106;
    }

    public int getStartX() {
        return TabGUI.calculateStartX(this.priority);
    }

    public int getStartY() {
        return 30;
    }

    public void expand() {
        this.expanded = true;
        this.animation.changeDirection(Animation.Direction.BACKWARDS);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isFullyCollapsed() {
        return this.expanded && this.animation.calcPercent() == 0.0f;
    }

    public int getHeight() {
        return 100;
    }

    public void render(float partialTicks) {
        float transitionFactor = MathHelper.calculateTransition(this.animation.calcPercent(), 0.0f, 1.0f, 1.0f);
        if (this.animation.getDirection() == Animation.Direction.BACKWARDS) {
            transitionFactor = MathHelper.calculateBackwardTransition(this.animation.calcPercent(), 0.0f, 1.0f, 1.0f);
        }
        RenderUtil.startScissor(this.getStartX(), this.getStartY(), (float)this.getWidth() * transitionFactor, this.getHeight());
        this.drawContent(partialTicks);
        RenderUtil.restoreScissor();
    }

    public void drawContent(float partialTicks) {
    }
}

