/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.client.network.youtube;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mentalfrostbyte.jello.util.client.network.youtube.YoutubeJPGThumbnail;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ThumbnailUtil {
    public static YoutubeJPGThumbnail[] search(String searchTags) {
        return ThumbnailUtil.extractYoutubeThumbnailsFromHtml(ThumbnailUtil.fetchUrlContent("https://www.google.com/search?client=safari&num=21&gbv=1&tbm=vid&oq=&aqs=&q=site%3Ayoutube.com+" + ThumbnailUtil.encodeUrlParameter(searchTags)));
    }

    public static YoutubeJPGThumbnail[] getFromChannel(String channelId) {
        return ThumbnailUtil.extractYoutubeThumbnails(ThumbnailUtil.fetchUrlContent("https://www.youtube.com/@" + channelId + "/videos?disable_polymer=1"));
    }

    public static YoutubeJPGThumbnail[] getFromPlaylist(String playlistId) {
        return ThumbnailUtil.extractYoutubeThumbnails(ThumbnailUtil.fetchUrlContent("https://www.youtube.com/playlist?list=" + playlistId + "&disable_polymer=1"));
    }

    public static YoutubeJPGThumbnail[] extractYoutubeThumbnails(String htmlContent) {
        if (htmlContent.startsWith("[")) {
            try {
                JsonArray jsonArray = JsonParser.parseString((String)htmlContent).getAsJsonArray();
                htmlContent = jsonArray.get(1).getAsJsonObject().getAsJsonObject("body").get("content").getAsString();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        ArrayList<YoutubeJPGThumbnail> thumbnails = new ArrayList<YoutubeJPGThumbnail>();
        Pattern pattern = Pattern.compile("r\":\\{\"videoId\":\"(.{11})\"(.*?)\"text\":\"(.{1,100})\"\\}]", 8);
        Matcher matcher = pattern.matcher(htmlContent.replace("\n", "").replace("\r", ""));
        block2: while (matcher.find()) {
            for (YoutubeJPGThumbnail thumbnail : thumbnails) {
                if (thumbnail == null || !thumbnail.videoID.equals(matcher.group(1))) continue;
                continue block2;
            }
            thumbnails.add(new YoutubeJPGThumbnail(matcher.group(1), ThumbnailUtil.decodeAndUnescapeUrl(StringEscapeUtils.unescapeJava((String)matcher.group(3)))));
        }
        return thumbnails.toArray(new YoutubeJPGThumbnail[0]);
    }

    public static YoutubeJPGThumbnail[] extractYoutubeThumbnailsFromHtml(String htmlContent) {
        if (htmlContent.startsWith("[")) {
            try {
                JsonArray jsonArray = JsonParser.parseString((String)htmlContent).getAsJsonArray();
                htmlContent = jsonArray.get(1).getAsJsonObject().getAsJsonObject("body").get("content").getAsString();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        ArrayList<YoutubeJPGThumbnail> thumbnails = new ArrayList<YoutubeJPGThumbnail>();
        Pattern pattern = Pattern.compile("<a(.*?)watch%3Fv%3D(.{11})[\\\"&](.*?)><div (.*?)>(.{1,100}) - YouTube<\\/div><\\/h3>", 8);
        Matcher matcher = pattern.matcher(htmlContent.replace("\n", "").replace("\r", ""));
        block2: while (matcher.find()) {
            if (matcher.group(5).contains("</") || matcher.group(5).equals(" ") || matcher.group(5).length() == 0 || matcher.group(1).contains("play-all")) continue;
            for (Object e : thumbnails) {
                if (!(e instanceof YoutubeJPGThumbnail) || !((YoutubeJPGThumbnail)e).videoID.equals(matcher.group(2))) continue;
                continue block2;
            }
            thumbnails.add(new YoutubeJPGThumbnail(matcher.group(2), ThumbnailUtil.decodeAndUnescapeUrl(matcher.group(5).replaceAll("<(.*?)>", ""))));
        }
        return thumbnails.toArray(new YoutubeJPGThumbnail[0]);
    }

    private static String decodeAndUnescapeUrl(String url) {
        String fullUrl;
        try {
            fullUrl = StringEscapeUtils.unescapeHtml4((String)URLDecoder.decode(url, StandardCharsets.UTF_8)).trim();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(url);
            return "https://www.youtube.com/watch?v=dQw4w9WgXcQ";
        }
        return fullUrl;
    }

    private static String encodeUrlParameter(String url) {
        String fullUrl = URLEncoder.encode(url, StandardCharsets.UTF_8);
        return fullUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchUrlContent(String url) {
        System.out.println(":" + url);
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("ChatCommandExecutor-Agent", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)");
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
            String stringContent;
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = "";
                return string;
            }
            String output = stringContent = EntityUtils.toString((HttpEntity)entity);
            return output;
        }
        catch (IOException | IllegalStateException | ParseException e) {
            e.printStackTrace();
            return "";
        }
    }
}

