/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.settings.impl;

import com.google.gson.JsonObject;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.SettingType;
import com.mentalfrostbyte.jello.util.system.other.GsonUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ColorSetting
extends Setting<Integer> {
    public boolean rainbow = false;

    public ColorSetting(String name, String description, int defaultColor, boolean rainbow) {
        super(name, description, SettingType.COLOR, defaultColor);
        this.rainbow = rainbow;
    }

    public ColorSetting(String name, String description, int defaultColor) {
        super(name, description, SettingType.COLOR, defaultColor);
    }

    @Override
    public JsonObject loadCurrentValueFromJSONObject(JsonObject jsonObject) {
        this.currentValue = GsonUtil.getIntOrDefault(jsonObject, "value", this.getDefaultColor());
        this.rainbow = GsonUtil.getBooleanOrDefault(jsonObject, "rainbow", false);
        return jsonObject;
    }

    @Override
    public JsonObject buildUpSettingData(JsonObject jsonObject) {
        jsonObject.addProperty("name", this.getName());
        jsonObject.addProperty("value", (Number)this.getCurrentValue());
        jsonObject.addProperty("rainbow", Boolean.valueOf(this.rainbow));
        return jsonObject;
    }

    @Override
    @NotNull
    public Integer getCurrentValue() {
        if (!this.rainbow) {
            return (Integer)this.currentValue;
        }
        Color color = new Color((Integer)this.currentValue);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor((float)(System.currentTimeMillis() % 4000L) / 4000.0f, hsb[1], hsb[2]).getRGB();
    }

    public Integer getDefaultColor() {
        return (Integer)this.currentValue;
    }
}

