/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.world.disabler;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.network.EventSendPacket;
import com.mentalfrostbyte.jello.gui.impl.others.ChatUtil;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.util.PacketCollectorUtil;
import java.util.Arrays;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import team.sdhq.eventBus.annotations.EventTarget;

public class CustomDisabler
extends Module {
    public CustomDisabler() {
        super(ModuleCategory.EXPLOIT, "Custom", "Customizable disabler ");
        this.registerSetting((Setting)new BooleanSetting("Log cancelled packets", "Logs what type of packets were cancelled", false));
        Arrays.stream(PacketCollectorUtil.getPacketClasses("Outgoing")).sorted().map(packetClass -> new BooleanSetting((String)packetClass, "Cancel Outgoing " + packetClass, false)).forEach(this::registerSetting);
        Arrays.stream(PacketCollectorUtil.getPacketClasses("Incoming")).sorted().map(packetClass -> new BooleanSetting((String)packetClass, "Cancel Incoming " + packetClass, false)).forEach(this::registerSetting);
        Arrays.stream(CEntityActionPacket.Action.values()).map(action -> new BooleanSetting(action.name(), "Cancel CEntityActionPacket " + action.name(), false)).forEach(this::registerSetting);
        Arrays.stream(CPlayerDiggingPacket.Action.values()).map(action -> new BooleanSetting(action.name(), "Cancel CPlayerDiggingPacket " + action.name(), false)).forEach(this::registerSetting);
    }

    public void logCancelled(String name, String type) {
        ChatUtil.printMessage("Cancelling " + type + ": " + name);
    }

    @EventTarget
    public void onRecievePacket(EventReceivePacket event) {
        String packetName = event.packet.getClass().getSimpleName();
        if (this.getBooleanValueFromSettingName(packetName)) {
            this.logCancelled(packetName, "INCOMING packet");
            event.cancelled = true;
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        CEntityActionPacket entityAction;
        CPlayerDiggingPacket diggingPacket;
        Object actionName;
        IPacket<?> iPacket;
        String packetName = event.packet.getClass().getSimpleName();
        if (this.getBooleanValueFromSettingName(packetName)) {
            this.logCancelled(packetName, "OUTGOING packet");
            event.cancelled = true;
        }
        if ((iPacket = event.packet) instanceof CPlayerDiggingPacket && this.getBooleanValueFromSettingName((String)(actionName = (diggingPacket = (CPlayerDiggingPacket)iPacket).getAction().name()))) {
            this.logCancelled((String)actionName, "CPlayerDiggingPacket action");
            ChatUtil.printMessage("Cancelling CPlayerDiggingPacket action: " + (String)actionName);
            event.cancelled = true;
        }
        if ((actionName = event.packet) instanceof CEntityActionPacket && this.getBooleanValueFromSettingName((String)(actionName = (entityAction = (CEntityActionPacket)actionName).getAction().name()))) {
            ChatUtil.printMessage("Cancelling CEntityActionPacket action: " + (String)actionName);
            event.cancelled = true;
        }
    }
}

