/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render.projectiles;

import com.mentalfrostbyte.jello.module.impl.render.Projectiles;
import com.mentalfrostbyte.jello.module.impl.render.projectiles.ProjectileThingyPredicate;
import com.mentalfrostbyte.jello.module.impl.render.projectiles.TraceThing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public final class ProjectileItems
extends Enum<ProjectileItems> {
    public static final /* enum */ ProjectileItems BOW = new ProjectileItems(Items.BOW, 0.0f, 3.0f, 0.0f);
    public static final /* enum */ ProjectileItems SNOWBALL = new ProjectileItems(Items.SNOWBALL, 0.0f, 1.875f, 0.0f);
    public static final /* enum */ ProjectileItems ENDER_PEARL = new ProjectileItems(Items.ENDER_PEARL, 0.0f, 1.875f, 0.0f);
    public static final /* enum */ ProjectileItems EGG = new ProjectileItems(Items.EGG, 0.0f, 1.875f, 0.0f);
    public static final /* enum */ ProjectileItems SPLASH_POTION = new ProjectileItems(Items.SPLASH_POTION, 0.0f, 0.5f, 0.0f);
    public static final /* enum */ ProjectileItems EXPERIENCE_BOTTLE = new ProjectileItems(Items.EXPERIENCE_BOTTLE, 0.0f, 0.6f, 0.0f);
    public static final /* enum */ ProjectileItems TRIDENT = new ProjectileItems(Items.TRIDENT, 0.0f, 2.5f, 0.0f);
    private final Item item;
    private final float posX;
    private final float posY;
    private final float posZ;
    public double traceX;
    public double traceY;
    public double traceZ;
    public float traceXOffset;
    public float traceYOffset;
    public float traceZOffset;
    public RayTraceResult rayTraceResult;
    public Entity hit;
    private static final /* synthetic */ ProjectileItems[] $VALUES;

    public static ProjectileItems[] values() {
        return (ProjectileItems[])$VALUES.clone();
    }

    public static ProjectileItems valueOf(String name) {
        return Enum.valueOf(ProjectileItems.class, name);
    }

    private ProjectileItems(Item item, float posX, float posY, float posZ) {
        this.item = item;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public float getPosY() {
        if (!this.item.equals(Items.BOW)) {
            return this.posY;
        }
        return !(this.posY * BowItem.getArrowVelocity(Projectiles.mc.player.getItemInUseCount()) > 0.0f) ? BowItem.getArrowVelocity(20) : BowItem.getArrowVelocity(Projectiles.mc.player.getItemInUseCount());
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosZ() {
        return this.posZ;
    }

    public Item getItem() {
        return this.item;
    }

    public static ProjectileItems getProjectileThingyForItem(Item item) {
        for (ProjectileItems var6 : ProjectileItems.values()) {
            if (!var6.getItem().equals(item)) continue;
            return var6;
        }
        return null;
    }

    public List<TraceThing> getTraceThings() {
        ArrayList<TraceThing> list = new ArrayList<TraceThing>();
        assert (Projectiles.mc.player != null);
        float var4 = (float)Math.toRadians(Projectiles.mc.player.rotationYaw);
        float var5 = (float)Math.toRadians(Projectiles.mc.player.rotationPitch);
        double var6 = Projectiles.mc.player.lastTickPosX + (Projectiles.mc.player.getPosX() - Projectiles.mc.player.lastTickPosX) * (double)Projectiles.mc.timer.renderPartialTicks;
        double var8 = Projectiles.mc.player.lastTickPosY + (Projectiles.mc.player.getPosY() - Projectiles.mc.player.lastTickPosY) * (double)Projectiles.mc.timer.renderPartialTicks;
        double var10 = Projectiles.mc.player.lastTickPosZ + (Projectiles.mc.player.getPosZ() - Projectiles.mc.player.lastTickPosZ) * (double)Projectiles.mc.timer.renderPartialTicks;
        this.traceX = var6;
        this.traceY = var8 + (double)Projectiles.mc.player.getEyeHeight() - (double)0.1f;
        this.traceZ = var10;
        float var12 = Math.min(20.0f, (float)(72000 - Projectiles.mc.player.getItemInUseCount()) + Projectiles.mc.getRenderPartialTicks()) / 20.0f;
        this.traceXOffset = -MathHelper.sin(var4) * MathHelper.cos(var5) * this.posY * var12;
        this.traceYOffset = -MathHelper.sin(var5) * this.posY * var12;
        this.traceZOffset = MathHelper.cos(var4) * MathHelper.cos(var5) * this.posY * var12;
        this.rayTraceResult = null;
        this.hit = null;
        list.add(new TraceThing(this.traceX, this.traceY, this.traceZ));
        while (this.rayTraceResult == null && this.hit == null && this.traceY > 0.0) {
            Vector3d startVec = new Vector3d(this.traceX, this.traceY, this.traceZ);
            Vector3d endVec = new Vector3d(this.traceX + (double)this.traceXOffset, this.traceY + (double)this.traceYOffset, this.traceZ + (double)this.traceZOffset);
            float size = (float)(!(this.item instanceof BowItem) ? 0.25 : 0.3);
            AxisAlignedBB boundingBox = new AxisAlignedBB(this.traceX - (double)size, this.traceY - (double)size, this.traceZ - (double)size, this.traceX + (double)size, this.traceY + (double)size, this.traceZ + (double)size);
            assert (Projectiles.mc.world != null);
            List<Entity> entities = Projectiles.mc.world.getEntitiesInAABBexcluding(Projectiles.mc.player, boundingBox.offset(this.traceXOffset, this.traceYOffset, this.traceZOffset).grow(1.0, 1.0, 1.0), EntityPredicates.NOT_SPECTATING.and((Predicate<Entity>)((Object)new ProjectileThingyPredicate(this, size, startVec, endVec))));
            if (!entities.isEmpty()) {
                Iterator<Entity> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    Entity entity;
                    this.hit = entity = iterator.next();
                }
                break;
            }
            BlockRayTraceResult trace = Projectiles.mc.world.rayTraceBlocks(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, Projectiles.mc.player));
            if (trace != null && trace.getType() != RayTraceResult.Type.MISS) {
                this.rayTraceResult = trace;
                this.traceX = this.rayTraceResult.getHitVec().x;
                this.traceY = this.rayTraceResult.getHitVec().y;
                this.traceZ = this.rayTraceResult.getHitVec().z;
                list.add(new TraceThing(this.traceX, this.traceY, this.traceZ));
                break;
            }
            float offsetMultiplier = 0.99f;
            float yOffsetDecrement = 0.05f;
            this.traceX += (double)this.traceXOffset;
            this.traceY += (double)this.traceYOffset;
            this.traceZ += (double)this.traceZOffset;
            list.add(new TraceThing(this.traceX, this.traceY, this.traceZ));
            this.traceXOffset *= offsetMultiplier;
            this.traceYOffset *= offsetMultiplier;
            this.traceZOffset *= offsetMultiplier;
            this.traceYOffset -= yOffsetDecrement;
        }
        return list;
    }

    private static /* synthetic */ ProjectileItems[] $values() {
        return new ProjectileItems[]{BOW, SNOWBALL, ENDER_PEARL, EGG, SPLASH_POTION, EXPERIENCE_BOTTLE, TRIDENT};
    }

    static {
        $VALUES = ProjectileItems.$values();
    }
}

