/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render.jello.esp;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderEntity;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderNameTag;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.render.jello.esp.util.Class2329;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.ColorSetting;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.world.PositionUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.TextureImpl;
import team.sdhq.eventBus.annotations.EventTarget;

public class ShadowESP
extends Module {
    public static RenderState currentRenderMode = RenderState.DEFAULT;
    public IRenderTypeBuffer.Impl renderBuffer;

    public ShadowESP() {
        super(ModuleCategory.RENDER, "Shadow", "Draws a line arround entities");
        this.renderBuffer = IRenderTypeBuffer.getImpl(ShadowESP.mc.getRenderTypeBuffers().fixedBuffers, new BufferBuilder(256));
        this.registerSetting((Setting)new ColorSetting("Color", "The tracers color", ClientColors.LIGHT_GREYISH_BLUE.getColor()));
    }

    @EventTarget
    public void onRender(EventRender3D event) {
        if (ShadowESP.mc.player != null && ShadowESP.mc.world != null) {
            this.method16612();
            RenderUtil.method11476();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.applyRenderMode(RenderState.PRE_RENDER);
            RenderUtil.method11477(Class2329.field15941);
            GL11.glLineWidth((float)1.0f);
            this.method16606();
            this.applyRenderMode(RenderState.OUTLINE);
            RenderSystem.alphaFunc(518, 0.0f);
            RenderSystem.enableAlphaTest();
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)0.1f);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.method11478();
            this.method16613();
            this.renderBuffer.finish();
        }
    }

    public void method16606() {
        int color = RenderUtil.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.8f);
        ShadowESP.mc.world.entitiesById.forEach((i, entity) -> {
            if (this.isValid((Entity)entity)) {
                double var6 = PositionUtil.getRelativePosition((Entity)entity).x;
                double var8 = PositionUtil.getRelativePosition((Entity)entity).y;
                double var10 = PositionUtil.getRelativePosition((Entity)entity).z;
                GL11.glPushMatrix();
                GL11.glAlphaFunc((int)519, (float)0.0f);
                GL11.glTranslated((double)var6, (double)var8, (double)var10);
                GL11.glTranslatef((float)0.0f, (float)entity.getHeight(), (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
                GL11.glRotatef((float)ShadowESP.mc.gameRenderer.getActiveRenderInfo().getYaw(), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glScalef((float)-0.11f, (float)-0.11f, (float)-0.11f);
                RenderUtil.drawImage2(-entity.getWidth() * 22.0f, -entity.getHeight() * 5.5f, entity.getWidth() * 44.0f, entity.getHeight() * 21.0f, Resources.shadowPNG, color, false);
                Resources.shoutIconPNG.bind();
                GL11.glPopMatrix();
            }
        });
    }

    public void applyRenderMode(RenderState renderState) {
        GL11.glDepthFunc((int)519);
        currentRenderMode = renderState;
        int colorValue = this.parseSettingValueToIntBySettingName("Color");
        float alpha = (float)(colorValue >> 24 & 0xFF) / 255.0f;
        float red = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorValue & 0xFF) / 255.0f;
        GL11.glEnable((int)2896);
        GL11.glLightModelfv((int)2899, (float[])new float[]{red, green, blue, alpha});
        RenderSystem.enableLighting();
        if (currentRenderMode == RenderState.OUTLINE) {
            GL11.glEnable((int)10754);
            GL11.glLineWidth((float)2.0f);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2896);
        }
        for (Entity entity : ShadowESP.mc.world.getAllEntities()) {
            if (!this.isValid(entity)) continue;
            GL11.glPushMatrix();
            Vector3d renderVector = ShadowESP.mc.gameRenderer.getActiveRenderInfo().getPos();
            double renderPosX = renderVector.getX();
            double renderPosY = renderVector.getY();
            double renderPosZ = renderVector.getZ();
            MatrixStack matrix = new MatrixStack();
            boolean shadows = ShadowESP.mc.gameSettings.entityShadows;
            RenderSystem.disableLighting();
            RenderSystem.color4f(0.0f, 0.0f, 1.0f, 0.5f);
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            RenderSystem.enableBlend();
            ShadowESP.mc.gameSettings.entityShadows = false;
            int fireTimer = entity.getFireTimer();
            boolean burning = entity.getFlag(0);
            entity.setFire(0);
            entity.setFlag(0, false);
            this.renderEntity(entity, renderPosX, renderPosY, renderPosZ, ShadowESP.mc.timer.renderPartialTicks, matrix, this.renderBuffer);
            entity.setFire(fireTimer);
            entity.setFlag(0, burning);
            ShadowESP.mc.gameSettings.entityShadows = shadows;
            GL11.glPopMatrix();
        }
        this.renderBuffer.finish(RenderType.getEntitySolid(AtlasTexture.LOCATION_BLOCKS_TEXTURE));
        this.renderBuffer.finish(RenderType.getEntityCutout(AtlasTexture.LOCATION_BLOCKS_TEXTURE));
        this.renderBuffer.finish(RenderType.getEntityCutoutNoCull(AtlasTexture.LOCATION_BLOCKS_TEXTURE));
        this.renderBuffer.finish(RenderType.getEntitySmoothCutout(AtlasTexture.LOCATION_BLOCKS_TEXTURE));
        this.renderBuffer.finish(RenderType.getLines());
        this.renderBuffer.finish();
        if (currentRenderMode == RenderState.OUTLINE) {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glDisable((int)10754);
        }
        currentRenderMode = RenderState.DEFAULT;
        GL11.glDepthFunc((int)515);
    }

    public void renderEntity(Entity entity, double offsetX, double offsetY, double offsetZ, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer) {
        double interpolatedX = MathHelper.lerp((double)partialTicks, entity.lastTickPosX, entity.getPosX());
        double interpolatedY = MathHelper.lerp((double)partialTicks, entity.lastTickPosY, entity.getPosY());
        double interpolatedZ = MathHelper.lerp((double)partialTicks, entity.lastTickPosZ, entity.getPosZ());
        float interpolatedYaw = MathHelper.lerp(partialTicks, entity.prevRotationYaw, entity.rotationYaw);
        ShadowESP.mc.worldRenderer.renderManager.renderEntityStatic(entity, interpolatedX - offsetX, interpolatedY - offsetY, interpolatedZ - offsetZ, interpolatedYaw, partialTicks, matrixStack, typeBuffer, 238);
    }

    @EventTarget
    public void onRenderEntity(EventRenderEntity event) {
        if (currentRenderMode != RenderState.DEFAULT) {
            event.method13957(false);
        }
    }

    @EventTarget
    public void onNametagRender(EventRenderNameTag event) {
        if (currentRenderMode != RenderState.DEFAULT && event.getEntity() instanceof PlayerEntity) {
            event.cancelled = true;
        }
    }

    public boolean isValid(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                if (!(entity instanceof ClientPlayerEntity)) {
                    return !entity.isInvisible() && !Client.getInstance().botManager.isBot(entity);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void method16612() {
        GL11.glLineWidth((float)3.0f);
        GL11.glPointSize((float)3.0f);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2903);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ShadowESP.mc.gameRenderer.lightmapTexture.enableLightmap();
    }

    private void method16613() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
        TextureImpl.unbind();
        mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
        ShadowESP.mc.gameRenderer.lightmapTexture.enableLightmap();
        GL11.glLightModelfv((int)2899, (float[])new float[]{0.4f, 0.4f, 0.4f, 1.0f});
        currentRenderMode = RenderState.DEFAULT;
    }

    public static enum RenderState {
        DEFAULT,
        PRE_RENDER,
        OUTLINE;

    }
}

