/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render.chestesp;

import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.game.world.BoundingBox;
import com.mentalfrostbyte.jello.util.game.world.PositionUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TrappedChestTileEntity;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.TextureImpl;
import team.sdhq.eventBus.annotations.EventTarget;

public class BoxChestESP
extends Module {
    public BoxChestESP() {
        super(ModuleCategory.RENDER, "Box", "Draws a box where chests are");
    }

    @EventTarget
    public void onRender3D(EventRender3D event) {
        if (this.isEnabled() && BoxChestESP.mc.player != null && BoxChestESP.mc.world != null) {
            this.prepareRenderSettings();
            this.renderChestBoxes();
            this.applyTextureSettings();
        }
    }

    private void renderChestBoxes() {
        int regularColor = RenderUtil2.applyAlpha(this.access().parseSettingValueToIntBySettingName("Regular Color"), 0.14f);
        int enderColor = RenderUtil2.applyAlpha(this.access().parseSettingValueToIntBySettingName("Ender Color"), 0.14f);
        int trappedColor = RenderUtil2.applyAlpha(this.access().parseSettingValueToIntBySettingName("Trapped Color"), 0.14f);
        for (TileEntity tileEntity : BoxChestESP.mc.world.loadedTileEntityList) {
            boolean showTrappedChests;
            boolean showRegularChests = tileEntity instanceof ChestTileEntity && !(tileEntity instanceof TrappedChestTileEntity) && this.access().getBooleanValueFromSettingName("Show Regular Chests");
            boolean showEnderChests = tileEntity instanceof EnderChestTileEntity && this.access().getBooleanValueFromSettingName("Show Ender Chests");
            boolean bl = showTrappedChests = tileEntity instanceof TrappedChestTileEntity && this.access().getBooleanValueFromSettingName("Show Trapped Chests");
            if (!showRegularChests && !showEnderChests && !showTrappedChests) continue;
            double x = PositionUtil.getRelativePosition((BlockPos)tileEntity.getPos()).x;
            double y = PositionUtil.getRelativePosition((BlockPos)tileEntity.getPos()).y;
            double z = PositionUtil.getRelativePosition((BlockPos)tileEntity.getPos()).z;
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            int color = regularColor;
            if (tileEntity instanceof TrappedChestTileEntity) {
                color = trappedColor;
            } else if (tileEntity instanceof EnderChestTileEntity) {
                color = enderColor;
            }
            BoundingBox boundingBox = new BoundingBox(tileEntity.getBlockState().getShape(BoxChestESP.mc.world, tileEntity.getPos()).getBoundingBox().offset(x, y, z));
            GL11.glAlphaFunc((int)519, (float)0.0f);
            RenderUtil.render3DColoredBox(boundingBox, color);
            RenderUtil.renderWireframeBox(boundingBox, 2.0f, color);
            GL11.glDisable((int)3042);
        }
    }

    private void prepareRenderSettings() {
        GL11.glLineWidth((float)3.0f);
        GL11.glPointSize((float)3.0f);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2903);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BoxChestESP.mc.gameRenderer.lightmapTexture.disableLightmap();
    }

    private void applyTextureSettings() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2903);
        RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
        TextureImpl.unbind();
        mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
        BoxChestESP.mc.gameRenderer.lightmapTexture.enableLightmap();
    }
}

