/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc.gameplay;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.misc.GamePlay;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.util.client.logger.TimedMessage;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.lang3.StringUtils;
import team.sdhq.eventBus.annotations.EventTarget;

public class HypixelGamePlay
extends Module {
    private GamePlay parentModule;

    public HypixelGamePlay() {
        super(ModuleCategory.MISC, "Hypixel", "Gameplay for Hypixel");
        this.registerSetting((Setting)new BooleanSetting("FriendAccept", "Automatically accept friend requests", false));
        this.registerSetting((Setting)new BooleanSetting("Hide infos", "Hide scoreboard server informations & date when ingame", false));
    }

    @Override
    public void initialize() {
        this.parentModule = (GamePlay)this.access();
    }

    @EventTarget
    public void onReceive(EventReceivePacket event) {
        if (HypixelGamePlay.mc.player != null) {
            IPacket<?> packet = event.packet;
            if (packet instanceof SChatPacket) {
                ClickEvent clickEvent;
                SChatPacket chatPacket = (SChatPacket)packet;
                String text = chatPacket.getChatComponent().getString().replaceAll("\u00a7.", "");
                if (chatPacket.getType() != ChatType.SYSTEM && chatPacket.getType() != ChatType.CHAT) {
                    return;
                }
                String playerName = HypixelGamePlay.mc.player.getName().getString().toLowerCase();
                if (this.parentModule.getBooleanValueFromSettingName("AutoL")) {
                    String[] splitText;
                    String[] killTypes = new String[]{"MULTI ", "PENTA ", "QUADRA ", "TRIPLE ", "DOUBLE ", ""};
                    boolean confirmedKill = false;
                    for (String killType : killTypes) {
                        if (!text.startsWith(killType + "KILL! ")) continue;
                        confirmedKill = true;
                        break;
                    }
                    if (confirmedKill && (splitText = text.split(" ")).length > 3) {
                        this.parentModule.processAutoLMessage(splitText[3]);
                    }
                    if (text.toLowerCase().contains("was killed by " + playerName) || text.toLowerCase().contains("was thrown into the void by " + playerName + ".") || text.toLowerCase().contains("was thrown off a cliff by " + playerName + ".") || text.toLowerCase().contains("was struck down by " + playerName + ".") || text.toLowerCase().contains("be sent to davy jones' locker by " + playerName + ".")) {
                        int colorIndex;
                        Scoreboard scoreboard = HypixelGamePlay.mc.world.getScoreboard();
                        ScoreObjective scoreobjective = null;
                        ScorePlayerTeam playerTeam = scoreboard.getPlayersTeam(HypixelGamePlay.mc.player.getScoreboardName());
                        if (playerTeam != null && (colorIndex = playerTeam.getColor().getColorIndex()) >= 0) {
                            scoreobjective = scoreboard.getObjectiveInDisplaySlot(3 + colorIndex);
                        }
                        ScoreObjective objective = scoreobjective != null ? scoreobjective : scoreboard.getObjectiveInDisplaySlot(1);
                        Collection<Score> sortedScores = scoreboard.getSortedScores(objective);
                        int playersLeft = -1;
                        for (Score score : sortedScores) {
                            ScorePlayerTeam scoreTeam = scoreboard.getPlayersTeam(score.getPlayerName());
                            String formattedName = ScorePlayerTeam.func_237500_a_(scoreTeam, new StringTextComponent(score.getPlayerName())).getString().replaceAll("\u00a7t", "");
                            for (String playersLeftKeyword : Arrays.asList("players left", "joueurs restants", "spieler verbleibend")) {
                                String[] splitName;
                                if (!formattedName.toLowerCase().contains(playersLeftKeyword + ":") || (splitName = formattedName.split(" ")).length <= 2) continue;
                                try {
                                    playersLeft = Integer.parseInt(splitName[2]);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            if (playersLeft <= 0) continue;
                            break;
                        }
                    }
                }
                if (this.getBooleanValueFromSettingName("FriendAccept") && text.contains("[ACCEPT] - [DENY] - [IGNORE]")) {
                    for (ITextComponent textCom : chatPacket.getChatComponent().getSiblings()) {
                        clickEvent = textCom.getStyle().getClickEvent();
                        if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND || !clickEvent.getValue().contains("/f accept")) continue;
                        MinecraftUtil.sendChatMessage(clickEvent.getValue());
                    }
                }
                if (text.contains("Want to play again? Click here! ") || text.contains("coins! (Win)")) {
                    if (this.parentModule.getBooleanValueFromSettingName("Auto Join")) {
                        for (ITextComponent textCom : chatPacket.getChatComponent().getSiblings()) {
                            clickEvent = textCom.getStyle().getClickEvent();
                            if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
                            this.parentModule.updateTimedMessage(new TimedMessage(clickEvent.getValue(), (long)this.parentModule.getNumberValueBySettingName("Auto Join delay") * 1000L));
                        }
                    }
                    if (this.parentModule.getBooleanValueFromSettingName("AutoGG")) {
                        this.parentModule.initializeAutoL();
                    }
                }
            } else if (packet instanceof STeamsPacket) {
                String teamPrefixSuffixCombined;
                String[] splitPrefixSuffix;
                STeamsPacket teamsPacket = (STeamsPacket)packet;
                if (this.getBooleanValueFromSettingName("Hide infos") && teamsPacket.getAction() == 2 && teamsPacket.getName().startsWith("team_") && (splitPrefixSuffix = (teamPrefixSuffixCombined = teamsPacket.getPrefix().getString() + teamsPacket.getSuffix().getString()).split(" ")) != null && splitPrefixSuffix.length > 1 && StringUtils.countMatches((CharSequence)splitPrefixSuffix[0], (CharSequence)"/") == 2) {
                    event.cancelled = true;
                }
            }
        }
    }
}

