/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderGUI;
import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.system.math.smoothing.QuadraticEasing;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.TrueTypeFont;
import team.sdhq.eventBus.annotations.EventTarget;

public class ActiveMods
extends Module {
    private int totalHeight;
    public HashMap<Module, Animation> animations = new HashMap();
    public TrueTypeFont font = ResourceRegistry.JelloLightFont20;
    private final List<Module> activeModules = new ArrayList<Module>();

    public ActiveMods() {
        super(ModuleCategory.GUI, "ActiveMods", "Renders active mods");
        this.registerSetting((Setting)new ModeSetting("Size", "The font size", 0, "Normal", "Small", "Tiny"));
        this.registerSetting((Setting)new BooleanSetting("Animations", "Scale in animation", true));
        this.registerSetting((Setting)new BooleanSetting("Sound", "Toggle sound", true));
        this.getSettingMap().get("Size").addObserver(set -> this.setFontSize());
        this.setAvailableOnClassic(false);
    }

    @Override
    public void onEnable() {
        this.setFontSize();
    }

    private void setFontSize() {
        switch (this.getStringSettingValueByName("Size")) {
            case "Normal": {
                this.font = ResourceRegistry.JelloLightFont20;
                break;
            }
            case "Small": {
                this.font = ResourceRegistry.JelloLightFont18;
                break;
            }
            default: {
                this.font = ResourceRegistry.JelloLightFont14;
            }
        }
    }

    @Override
    public void initialize() {
        this.activeModules.clear();
        for (Module module : Client.getInstance().moduleManager.getModuleMap().values()) {
            if (module.getCategory() == ModuleCategory.GUI) continue;
            this.activeModules.add(module);
            this.animations.put(module, new Animation(150, 150, Animation.Direction.BACKWARDS));
            if (!this.getBooleanValueFromSettingName("Animations")) continue;
            this.animations.get(module).changeDirection(!module.isEnabled() ? Animation.Direction.BACKWARDS : Animation.Direction.FORWARDS);
        }
        this.activeModules.sort(new ModuleNameLengthComparator());
    }

    @EventTarget
    public void onGUI(EventRenderGUI event) {
        if (Client.getInstance().clientMode == ClientMode.CLASSIC) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (ActiveMods.mc.player != null) {
            if (!event.pre) {
                GlStateManager.translatef(0.0f, -this.totalHeight, 0.0f);
            } else {
                Collection<Score> scores = this.getScores();
                int offset = 0;
                for (Module module : this.activeModules) {
                    if (!module.isEnabled()) continue;
                    ++offset;
                }
                int y = 23 + offset * (this.font.getHeight() + 1);
                int totalScores = scores.size();
                int windowHeight = Minecraft.getInstance().getMainWindow().getHeight();
                int windowCenterY = windowHeight / 2 - 14 * (totalScores - 3 + 2);
                if (y <= windowCenterY) {
                    this.totalHeight = 0;
                } else {
                    this.totalHeight = (y - windowCenterY) / 2;
                    GlStateManager.translatef(0.0f, this.totalHeight, 0.0f);
                }
            }
        }
    }

    @NotNull
    private Collection<Score> getScores() {
        int colorIndex;
        Scoreboard scoreboard = ActiveMods.mc.world.getScoreboard();
        ScoreObjective scoreobjective = null;
        ScorePlayerTeam playerTeam = scoreboard.getPlayersTeam(ActiveMods.mc.player.getScoreboardName());
        if (playerTeam != null && (colorIndex = playerTeam.getColor().getColorIndex()) >= 0) {
            scoreobjective = scoreboard.getObjectiveInDisplaySlot(3 + colorIndex);
        }
        ScoreObjective scoreObjective = scoreobjective != null ? scoreobjective : scoreboard.getObjectiveInDisplaySlot(1);
        return scoreboard.getSortedScores(scoreObjective);
    }

    @EventTarget
    public void onRender(EventRender2DOffset event) {
        if (Client.getInstance().clientMode == ClientMode.CLASSIC) {
            return;
        }
        if (ActiveMods.mc.player != null) {
            for (Module module : this.animations.keySet()) {
                if (!this.getBooleanValueFromSettingName("Animations")) continue;
                this.animations.get(module).changeDirection(!module.isEnabled() ? Animation.Direction.BACKWARDS : Animation.Direction.FORWARDS);
            }
            if (!Minecraft.getInstance().gameSettings.hideGUI) {
                int margin = 10;
                float scale = 1.0f;
                int screenWidth = Minecraft.getInstance().getMainWindow().getWidth();
                int screenHeight = margin - 4;
                if (this.font == ResourceRegistry.JelloLightFont14) {
                    margin -= 3;
                }
                if (Minecraft.getInstance().gameSettings.showDebugInfo) {
                    screenHeight = (int)((double)(ActiveMods.mc.ingameGUI.overlayDebug.debugInfoRight.size() * 9) * mc.getMainWindow().getGuiScaleFactor() + 7.0);
                }
                int color = RenderUtil2.applyAlpha(-1, 0.95f);
                for (Module module : this.activeModules) {
                    float animationScale = 1.0f;
                    float transparency = 1.0f;
                    if (!this.getBooleanValueFromSettingName("Animations")) {
                        if (!module.isEnabled()) {
                            continue;
                        }
                    } else {
                        Animation animation = this.animations.get(module);
                        if (animation.calcPercent() == 0.0f) continue;
                        transparency = animation.calcPercent();
                        animationScale = 0.86f + 0.14f * transparency;
                    }
                    String moduleName = module.getFormattedName();
                    GL11.glAlphaFunc((int)519, (float)0.0f);
                    GL11.glPushMatrix();
                    int xPos = screenWidth - margin - this.font.getWidth(moduleName) / 2;
                    int yPos = screenHeight + 12;
                    GL11.glTranslatef((float)xPos, (float)yPos, (float)0.0f);
                    GL11.glScalef((float)animationScale, (float)animationScale, (float)1.0f);
                    GL11.glTranslatef((float)(-xPos), (float)(-yPos), (float)0.0f);
                    float scaleFactor = (float)Math.sqrt(Math.min(1.2f, (float)this.font.getWidth(moduleName) / 63.0f));
                    RenderUtil.drawImage((float)screenWidth - (float)this.font.getWidth(moduleName) * 1.5f - (float)margin - 20.0f, (float)(screenHeight - 20), (float)this.font.getWidth(moduleName) * 3.0f, (float)this.font.getHeight() + scale + 40.0f, Resources.shadowPNG, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.36f * transparency * scaleFactor));
                    RenderUtil.drawString(this.font, screenWidth - margin - this.font.getWidth(moduleName), screenHeight, moduleName, transparency != 1.0f ? RenderUtil2.applyAlpha(-1, transparency * 0.95f) : color);
                    GL11.glPopMatrix();
                    screenHeight = (int)((float)screenHeight + ((float)this.font.getHeight() + scale) * QuadraticEasing.easeInOutQuad(transparency, 0.0f, 1.0f, 1.0f));
                }
            }
        }
    }

    private static class ModuleNameLengthComparator
    implements Comparator<Module> {
        private ModuleNameLengthComparator() {
        }

        @Override
        public int compare(Module module1, Module module2) {
            int length2;
            int length1 = ResourceRegistry.JelloLightFont20.getWidth(module1.getName());
            if (length1 <= (length2 = ResourceRegistry.JelloLightFont20.getWidth(module2.getName()))) {
                return length1 != length2 ? 1 : 0;
            }
            return -1;
        }
    }
}

