/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers.util.account.microsoft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;

public class Ban {
    private final String serverIP;
    private final Date date;

    public Ban(String serverIP, Date date) {
        this.serverIP = serverIP;
        this.date = date;
    }

    public Ban(JsonObject var1) throws JsonParseException {
        Calendar var4 = Calendar.getInstance();
        long bannedUntil = !(var1.get("until").getAsNumber() instanceof Integer) ? var1.get("until").getAsLong() : Integer.valueOf(var1.get("until").getAsInt()).longValue();
        if (bannedUntil == 1L) {
            bannedUntil = 0x7FFFFFFFFFFFFFFEL;
        }
        var4.setTimeInMillis(bannedUntil);
        this.serverIP = var1.get("server").getAsString();
        this.date = var4.getTime();
    }

    public JsonObject asJSONObject() {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("server", this.serverIP);
        jsonObj.addProperty("until", (Number)this.date.getTime());
        return jsonObj;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public Date getDate() {
        return this.date;
    }

    public ServerData getServer() {
        ServerList serverList = new ServerList(Minecraft.getInstance());
        serverList.loadServerList();
        int count = serverList.countServers();
        for (int i = 0; i < count; ++i) {
            ServerData serverData = serverList.getServerData(i);
            if (!serverData.serverIP.equals(this.serverIP)) continue;
            return serverData;
        }
        return null;
    }
}

