/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.gui.base.interfaces.OnlineProfileListener;
import com.mentalfrostbyte.jello.managers.util.profile.Profile;
import com.mentalfrostbyte.jello.module.Module;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;

public class OnlineProfilesManager {
    public static List<String> cachedOnlineProfiles;

    public OnlineProfilesManager(OnlineProfileListener listener) {
        new Thread(() -> {
            if (cachedOnlineProfiles == null) {
                cachedOnlineProfiles = this.fetchOnlineProfiles();
            }
            listener.onProfilesRetrieved(cachedOnlineProfiles);
        }).start();
    }

    public List<String> fetchOnlineProfiles() {
        block9: {
            ArrayList<String> arrayList;
            block10: {
                HttpGet request = new HttpGet("https://jelloconnect.sigmaclient.cloud/profiles.php?v=5.1.0");
                CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) break block9;
                InputStream inputStream = entity.getContent();
                try {
                    String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    JsonArray jsonArray = JsonParser.parseString((String)content).getAsJsonArray();
                    ArrayList<String> profileNames = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        profileNames.add(jsonArray.get(i).getAsString());
                    }
                    arrayList = profileNames;
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                inputStream.close();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private String encode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    public JsonObject fetchProfileConfig(String profileName) {
        block8: {
            JsonObject jsonObject;
            block9: {
                HttpGet request = new HttpGet("https://jelloconnect.sigmaclient.cloud/profiles/" + this.encode(profileName) + ".profile?v=5.1.0");
                CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) break block8;
                InputStream inputStream = entity.getContent();
                try {
                    String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                inputStream.close();
            }
            return jsonObject;
        }
        return new JsonObject();
    }

    public Profile createProfileFromOnlineConfig(Profile baseProfile, String profileName) {
        Profile newProfile = new Profile(profileName, baseProfile);
        try {
            newProfile.disableNonGuiModules();
            Profile settingsProfile = new Profile("settings", this.fetchProfileConfig(profileName).getAsJsonObject("modConfig"));
            for (Module module : Client.getInstance().moduleManager.getModuleMap().values()) {
                JsonObject moduleConfig = settingsProfile.getModuleConfig(module);
                if (moduleConfig == null) continue;
                newProfile.updateModuleConfig(moduleConfig, module);
            }
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Failed to parse profile configuration", e);
        }
        return newProfile;
    }
}

