/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.command.impl;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.command.Command;
import com.mentalfrostbyte.jello.gui.impl.jello.ingame.holders.KeyboardHolder;
import com.mentalfrostbyte.jello.managers.CommandManager;
import com.mentalfrostbyte.jello.managers.util.command.ChatCommandArguments;
import com.mentalfrostbyte.jello.managers.util.command.ChatCommandExecutor;
import com.mentalfrostbyte.jello.managers.util.command.CommandException;
import com.mentalfrostbyte.jello.module.Module;
import java.util.Map;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.StringTextComponent;

public class Bind
extends Command {
    public Bind() {
        super("bind", "Bind a module to a key", new String[0]);
        this.registerSubCommands("module");
        this.registerSubCommands("key/none");
    }

    @Override
    public void run(String var1, ChatCommandArguments[] args, ChatCommandExecutor executor) throws CommandException {
        if (args.length == 0) {
            CommandManager.runRunnable(() -> mc.displayGuiScreen(new KeyboardHolder(new StringTextComponent("GuiKeybinds"))));
            return;
        }
        if (args.length == 1) {
            Module module = this.getModuleByName(args[0].getArguments());
            if (module == null) {
                throw new CommandException("Module " + args[0].getArguments() + " not found");
            }
            int key = Client.getInstance().moduleManager.getKeyManager().method13729(module);
            String keyPrefix = "key.keyboard.";
            String foundKey = null;
            for (Map.Entry<String, InputMappings.Input> entry : InputMappings.Input.REGISTRY.entrySet()) {
                if (!entry.getKey().startsWith(keyPrefix) || entry.getValue().getKeyCode() != key) continue;
                foundKey = entry.getKey().substring(keyPrefix.length());
                break;
            }
            if (foundKey != null) {
                executor.send(module.getFormattedName() + " is bound to: " + foundKey);
            } else {
                executor.send("\u00a7c[Error] " + module.getFormattedName() + " is bound to an unknown key");
            }
            return;
        }
        if (args.length == 2) {
            Module module = this.getModuleByName(args[0].getArguments());
            if (module == null) {
                throw new CommandException("Module " + args[0].getArguments() + " not found");
            }
            int keyCode = this.getKeyCodeFromString(args[1].getArguments().toLowerCase());
            if (keyCode == -2) {
                throw new CommandException("Key " + args[1].getArguments() + " not found");
            }
            if (keyCode == -1) {
                Client.getInstance().moduleManager.getKeyManager().method13727(module);
                executor.send("Keybind was reset for module " + module.getFormattedName());
            } else {
                Client.getInstance().moduleManager.getKeyManager().method13725(keyCode, module);
                executor.send("Key " + args[1].getArguments() + " was set for module " + module.getFormattedName());
            }
            return;
        }
        throw new CommandException("Too many arguments");
    }

    public int getKeyCodeFromString(String name) {
        if (name.equals("none")) {
            return -1;
        }
        String keyPrefix = "key.keyboard.";
        for (Map.Entry<String, InputMappings.Input> entry : InputMappings.Input.REGISTRY.entrySet()) {
            String formatted;
            if (!entry.getKey().startsWith(keyPrefix) || !name.equalsIgnoreCase(formatted = entry.getKey().substring(keyPrefix.length()).replace("keypad.", "").replace(".", "_"))) continue;
            return entry.getValue().getKeyCode();
        }
        return -2;
    }

    public Module getModuleByName(String name) {
        String input = name.replaceAll("\\s+", "").toLowerCase();
        for (Module mod : Client.getInstance().moduleManager.getModuleMap().values()) {
            String modName = mod.getName().replaceAll("\u00a7.", "").replaceAll("\\s+", "").toLowerCase();
            if (!modName.equals(input)) continue;
            return mod;
        }
        return null;
    }
}

