/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte;

import club.minnced.discord.rpc.DiscordEventHandlers;
import club.minnced.discord.rpc.DiscordRPC;
import club.minnced.discord.rpc.DiscordRichPresence;
import com.google.gson.JsonObject;
import com.mentalfrostbyte.jello.managers.AccountManager;
import com.mentalfrostbyte.jello.managers.BotManager;
import com.mentalfrostbyte.jello.managers.CommandManager;
import com.mentalfrostbyte.jello.managers.FriendManager;
import com.mentalfrostbyte.jello.managers.GuiManager;
import com.mentalfrostbyte.jello.managers.ModuleManager;
import com.mentalfrostbyte.jello.managers.MusicManager;
import com.mentalfrostbyte.jello.managers.NotificationManager;
import com.mentalfrostbyte.jello.managers.SoundManager;
import com.mentalfrostbyte.jello.managers.ViaManager;
import com.mentalfrostbyte.jello.managers.WaypointsManager;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import com.mentalfrostbyte.jello.util.game.player.rotation.JelloAI;
import com.mentalfrostbyte.jello.util.game.player.tracker.MinerTracker;
import com.mentalfrostbyte.jello.util.game.player.tracker.PlayerStateTracker;
import com.mentalfrostbyte.jello.util.game.player.tracker.SlotChangeTracker;
import com.mentalfrostbyte.jello.util.game.render.BlurEngine;
import com.mentalfrostbyte.jello.util.system.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.newdawn.slick.opengl.Texture;

public class Client
implements MinecraftUtil {
    public static int currentVersionIndex = 28;
    public static final Logger logger = LogManager.getLogger((String)"Jello");
    public static final String RELEASE_TARGET = "5.1.0";
    public static final int BETA_ITERATION = 16;
    public static final String FULL_VERSION = "5.1.0b16";
    public File file = new File("sigma5");
    public static List<Texture> textureList = new ArrayList<Texture>();
    private static Client instance;
    public ClientMode clientMode = ClientMode.INDETERMINATE;
    public DiscordRichPresence discordRichPresence;
    public FriendManager friendManager;
    public SlotChangeTracker slotChangeTracker;
    public JsonObject config;
    public GuiManager guiManager;
    public ModuleManager moduleManager;
    public BotManager botManager;
    public ViaManager viaManager;
    public CommandManager commandManager;
    public SoundManager soundManager;
    public AccountManager accountManager;
    public WaypointsManager waypointsManager;
    public NotificationManager notificationManager;
    public MusicManager musicManager;
    public PlayerStateTracker playerTracker;
    public MinerTracker minerTracker;
    public static boolean dontRenderHand;
    public boolean loading = true;
    public BlurEngine blurEngine;

    public void start() {
        logger.info("Initializing...");
        try {
            if (!this.file.exists()) {
                this.file.mkdirs();
            }
            this.config = FileUtil.readFile(new File(String.valueOf(this.file) + "/config.json"));
        }
        catch (IOException exception) {
            logger.error((Object)exception);
        }
        JelloAI.init();
        this.guiManager = new GuiManager();
        this.botManager = new BotManager();
        this.botManager.init();
        this.viaManager = new ViaManager();
        this.viaManager.init();
        this.commandManager = new CommandManager();
        this.commandManager.init();
        this.friendManager = new FriendManager();
        this.friendManager.init();
        this.musicManager = new MusicManager();
        this.musicManager.init();
        this.soundManager = new SoundManager();
        this.soundManager.init();
        this.notificationManager = new NotificationManager();
        this.notificationManager.init();
        this.accountManager = new AccountManager();
        this.accountManager.init();
        this.playerTracker = new PlayerStateTracker();
        this.playerTracker.init();
        this.waypointsManager = new WaypointsManager();
        this.waypointsManager.init();
        this.blurEngine = new BlurEngine();
        this.blurEngine.init();
        this.minerTracker = new MinerTracker();
        this.minerTracker.init();
        GLFW.glfwSetWindowTitle((long)mc.getMainWindow().getHandle(), (CharSequence)"Sigma 5.1.0");
        logger.info("Initialized.");
    }

    public void shutdown() {
        logger.info("Shutting down...");
        try {
            if (this.guiManager != null) {
                this.guiManager.getUIConfig(this.config);
            }
            if (this.moduleManager != null) {
                this.moduleManager.method14660(this.config);
            }
            FileUtil.save(this.config, new File(String.valueOf(this.file) + "/config.json"));
        }
        catch (IOException exc) {
            logger.error("Unable to shutdown correctly. Config may be corrupt?", (Throwable)exc);
        }
        logger.info("Done.");
    }

    public void addTexture(Texture texture) {
        textureList.add(texture);
    }

    public static Client getInstance() {
        return instance != null ? instance : (instance = new Client());
    }

    private void initRPC() {
        DiscordRPC updatePresence = DiscordRPC.INSTANCE;
        DiscordEventHandlers eventHandlers = new DiscordEventHandlers();
        eventHandlers.ready = e -> logger.info("Discord RPC Ready!");
        updatePresence.Discord_Initialize("693493612754763907", eventHandlers, true, "var5");
        this.discordRichPresence = new DiscordRichPresence();
        this.discordRichPresence.startTimestamp = System.currentTimeMillis() / 1000L;
        this.discordRichPresence.state = "Playing Minecraft";
        this.discordRichPresence.details = "Jello for Sigma";
        this.discordRichPresence.largeImageKey = "jello";
        updatePresence.Discord_UpdatePresence(this.discordRichPresence);
    }

    public void setupClient(ClientMode mode) {
        this.clientMode = mode;
        this.moduleManager = new ModuleManager();
        this.moduleManager.reset();
        if (mode == ClientMode.CLASSIC) {
            this.guiManager.useClassic();
            DiscordRPC.INSTANCE.Discord_ClearPresence();
            GLFW.glfwSetWindowTitle((long)mc.getMainWindow().getHandle(), (CharSequence)"Classic Sigma 5.1.0");
        } else if (mode == ClientMode.JELLO) {
            this.guiManager.useJello();
            this.initRPC();
            GLFW.glfwSetWindowTitle((long)mc.getMainWindow().getHandle(), (CharSequence)"Jello for Sigma 5.1.0");
        }
        this.moduleManager.register(this.clientMode);
        this.moduleManager.loadProfileFromJSON(this.config);
        this.moduleManager.loadCurrentConfig(this.config);
        System.gc();
    }

    public void saveClientData() {
        try {
            FileUtil.save(this.config, new File(String.valueOf(this.file) + "/config.json"));
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    static {
        dontRenderHand = false;
    }
}

