/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.parser;

import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.DropTableEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.event.TruncateTableEvent;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.connectors.mysql.source.parser.CustomColumnDefinitionParserListener;
import org.apache.flink.cdc.connectors.mysql.utils.MySqlTypeUtils;
import org.apache.flink.cdc.connectors.shaded.org.antlr.v4.runtime.tree.ParseTreeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAlterTableParserListener
extends MySqlParserBaseListener {
    private static final int STARTING_INDEX = 1;
    private static final Logger LOG = LoggerFactory.getLogger(CustomAlterTableParserListener.class);
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private final LinkedList<SchemaChangeEvent> changes;
    private final boolean tinyInt1isBit;
    private TableId currentTable;
    private List<ColumnEditor> columnEditors;
    private CustomColumnDefinitionParserListener columnDefinitionListener;
    private TableEditor tableEditor;
    private int parsingColumnIndex = 1;

    public CustomAlterTableParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners, LinkedList<SchemaChangeEvent> changes, boolean tinyInt1isBit) {
        this.parser = parser;
        this.listeners = listeners;
        this.changes = changes;
        this.tinyInt1isBit = tinyInt1isBit;
    }

    @Override
    public void enterColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        io.debezium.relational.TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
        if (this.parser.databaseTables().forTable(tableId) == null) {
            this.tableEditor = this.parser.databaseTables().editOrCreateTable(tableId);
        }
        super.enterColumnCreateTable(ctx);
    }

    @Override
    public void exitColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.charsetForTable(this.tableEditor.tableId()));
            }
            this.listeners.remove(this.columnDefinitionListener);
            this.columnDefinitionListener = null;
            String defaultCharsetName = this.tableEditor.create().defaultCharsetName();
            this.tableEditor.setColumns(this.tableEditor.columns().stream().map(column -> {
                ColumnEditor columnEditor = column.edit();
                if (columnEditor.charsetNameOfTable() == null) {
                    columnEditor.charsetNameOfTable(defaultCharsetName);
                }
                return columnEditor;
            }).map(ColumnEditor::create).collect(Collectors.toList()));
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.parser.signalCreateTable(this.tableEditor.tableId(), ctx);
            Schema.Builder builder = Schema.newBuilder();
            this.tableEditor.columns().forEach(column -> builder.column(this.toCdcColumn((Column)column)));
            if (this.tableEditor.hasPrimaryKey()) {
                builder.primaryKey(this.tableEditor.primaryKeyColumnNames());
            }
            builder.comment(this.tableEditor.create().comment());
            this.changes.add((SchemaChangeEvent)new CreateTableEvent(this.toCdcTableId(this.tableEditor.tableId()), builder.build()));
        }, this.tableEditor);
        super.exitColumnCreateTable(ctx);
    }

    @Override
    public void enterColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.parser.parseName(ctx.uid());
            ColumnEditor columnEditor = Column.editor().name(columnName);
            if (this.columnDefinitionListener == null) {
                this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
                this.listeners.add(this.columnDefinitionListener);
            } else {
                this.columnDefinitionListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumnDeclaration(ctx);
    }

    @Override
    public void exitColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.addColumn(this.columnDefinitionListener.getColumn()), this.tableEditor, this.columnDefinitionListener);
        super.exitColumnDeclaration(ctx);
    }

    @Override
    public void enterPrimaryKeyTableConstraint(MySqlParser.PrimaryKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor), this.tableEditor);
        super.enterPrimaryKeyTableConstraint(ctx);
    }

    @Override
    public void enterUniqueKeyTableConstraint(MySqlParser.UniqueKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasPrimaryKey()) {
                this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor);
            }
        }, this.tableEditor);
        super.enterUniqueKeyTableConstraint(ctx);
    }

    @Override
    public void enterAlterTable(MySqlParser.AlterTableContext ctx) {
        this.currentTable = this.toCdcTableId(this.parser.parseQualifiedTableId(ctx.tableName().fullId()));
        super.enterAlterTable(ctx);
    }

    @Override
    public void exitAlterTable(MySqlParser.AlterTableContext ctx) {
        this.listeners.remove(this.columnDefinitionListener);
        super.exitAlterTable(ctx);
        this.currentTable = null;
    }

    @Override
    public void enterAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        String columnName = this.parser.parseName(ctx.uid(0));
        ColumnEditor columnEditor = Column.editor().name(columnName);
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.exitAlterByAddColumn(ctx);
    }

    @Override
    public void exitAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            if (ctx.FIRST() != null) {
                this.changes.add((SchemaChangeEvent)new AddColumnEvent(this.currentTable, Collections.singletonList(new AddColumnEvent.ColumnWithPosition(this.toCdcColumn(column), AddColumnEvent.ColumnPosition.FIRST, null))));
            } else if (ctx.AFTER() != null) {
                String afterColumn = this.parser.parseName(ctx.uid(1));
                this.changes.add((SchemaChangeEvent)new AddColumnEvent(this.currentTable, Collections.singletonList(new AddColumnEvent.ColumnWithPosition(this.toCdcColumn(column), AddColumnEvent.ColumnPosition.AFTER, afterColumn))));
            } else {
                this.changes.add((SchemaChangeEvent)new AddColumnEvent(this.currentTable, Collections.singletonList(new AddColumnEvent.ColumnWithPosition(this.toCdcColumn(column)))));
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByAddColumn(ctx);
    }

    @Override
    public void enterAlterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx) {
        this.columnEditors = new ArrayList<ColumnEditor>(ctx.uid().size());
        for (MySqlParser.UidContext uidContext : ctx.uid()) {
            String columnName = this.parser.parseName(uidContext);
            this.columnEditors.add(Column.editor().name(columnName));
        }
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, this.columnEditors.get(0), this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByAddColumns(ctx);
    }

    @Override
    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null && this.columnEditors.size() > this.parsingColumnIndex) {
                this.columnDefinitionListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
            }
        }, this.columnEditors);
        super.exitColumnDefinition(ctx);
    }

    @Override
    public void exitAlterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx) {
        this.parser.runIfNotNull(() -> {
            ArrayList addedColumns = new ArrayList();
            this.columnEditors.forEach(columnEditor -> {
                Column column = columnEditor.create();
                addedColumns.add(new AddColumnEvent.ColumnWithPosition(this.toCdcColumn(column)));
            });
            this.changes.add((SchemaChangeEvent)new AddColumnEvent(this.currentTable, addedColumns));
            this.listeners.remove(this.columnDefinitionListener);
            this.columnEditors = null;
            this.parsingColumnIndex = 1;
        }, this.columnEditors);
        super.exitAlterByAddColumns(ctx);
    }

    @Override
    public void enterAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        String oldColumnName = this.parser.parseName(ctx.oldColumn);
        ColumnEditor columnEditor = Column.editor().name(oldColumnName);
        columnEditor.unsetDefaultValueExpression();
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByChangeColumn(ctx);
    }

    @Override
    public void exitAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            String newColumnName = this.parser.parseName(ctx.newColumn);
            HashMap<String, DataType> typeMapping = new HashMap<String, DataType>();
            typeMapping.put(column.name(), MySqlTypeUtils.fromDbzColumn(column, this.tinyInt1isBit));
            this.changes.add((SchemaChangeEvent)new AlterColumnTypeEvent(this.currentTable, typeMapping));
            if (newColumnName != null && !column.name().equalsIgnoreCase(newColumnName)) {
                HashMap<String, String> renameMap = new HashMap<String, String>();
                renameMap.put(column.name(), newColumnName);
                this.changes.add((SchemaChangeEvent)new RenameColumnEvent(this.currentTable, renameMap));
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByChangeColumn(ctx);
    }

    @Override
    public void enterAlterByDropColumn(MySqlParser.AlterByDropColumnContext ctx) {
        String removedColName = this.parser.parseName(ctx.uid());
        this.changes.add((SchemaChangeEvent)new DropColumnEvent(this.currentTable, Collections.singletonList(removedColName)));
        super.enterAlterByDropColumn(ctx);
    }

    @Override
    public void enterAlterByRenameColumn(MySqlParser.AlterByRenameColumnContext ctx) {
        String oldColumnName = this.parser.parseName(ctx.oldColumn);
        ColumnEditor columnEditor = Column.editor().name(oldColumnName);
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByRenameColumn(ctx);
    }

    @Override
    public void enterAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        String oldColumnName = this.parser.parseName(ctx.uid(0));
        ColumnEditor columnEditor = Column.editor().name(oldColumnName);
        columnEditor.unsetDefaultValueExpression();
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByModifyColumn(ctx);
    }

    @Override
    public void exitAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            HashMap<String, DataType> typeMapping = new HashMap<String, DataType>();
            typeMapping.put(column.name(), MySqlTypeUtils.fromDbzColumn(column, this.tinyInt1isBit));
            this.changes.add((SchemaChangeEvent)new AlterColumnTypeEvent(this.currentTable, typeMapping));
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByModifyColumn(ctx);
    }

    @Override
    public void exitAlterByRenameColumn(MySqlParser.AlterByRenameColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            String newColumnName = this.parser.parseName(ctx.newColumn);
            if (newColumnName != null && !column.name().equalsIgnoreCase(newColumnName)) {
                HashMap<String, String> renameMap = new HashMap<String, String>();
                renameMap.put(column.name(), newColumnName);
                this.changes.add((SchemaChangeEvent)new RenameColumnEvent(this.currentTable, renameMap));
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByRenameColumn(ctx);
    }

    @Override
    public void exitTruncateTable(MySqlParser.TruncateTableContext ctx) {
        io.debezium.relational.TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
        this.changes.add((SchemaChangeEvent)new TruncateTableEvent(this.toCdcTableId(tableId)));
        super.exitTruncateTable(ctx);
    }

    @Override
    public void exitDropTable(MySqlParser.DropTableContext ctx) {
        ctx.tables().tableName().forEach(evt -> {
            io.debezium.relational.TableId tableId = this.parser.parseQualifiedTableId(evt.fullId());
            this.changes.add((SchemaChangeEvent)new DropTableEvent(this.toCdcTableId(tableId)));
        });
        super.exitDropTable(ctx);
    }

    @Override
    public void enterTableOptionComment(MySqlParser.TableOptionCommentContext ctx) {
        if (!this.parser.skipComments()) {
            this.parser.runIfNotNull(() -> {
                if (ctx.COMMENT() != null) {
                    this.tableEditor.setComment(MySqlAntlrDdlParser.withoutQuotes(ctx.STRING_LITERAL().getText()));
                }
            }, this.tableEditor);
        }
        super.enterTableOptionComment(ctx);
    }

    private org.apache.flink.cdc.common.schema.Column toCdcColumn(Column dbzColumn) {
        return org.apache.flink.cdc.common.schema.Column.physicalColumn((String)dbzColumn.name(), (DataType)MySqlTypeUtils.fromDbzColumn(dbzColumn, this.tinyInt1isBit), (String)dbzColumn.comment(), (String)dbzColumn.defaultValueExpression().orElse(null));
    }

    private TableId toCdcTableId(io.debezium.relational.TableId dbzTableId) {
        return TableId.tableId((String)dbzTableId.catalog(), (String)dbzTableId.table());
    }
}

