/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import io.debezium.connector.mysql.MySqlPartition;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.source.MetadataAccessor;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.utils.MySqlSchemaUtils;

@Internal
public class MySqlMetadataAccessor
implements MetadataAccessor {
    private final MySqlSourceConfig sourceConfig;
    private final MySqlPartition partition;

    public MySqlMetadataAccessor(MySqlSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
        this.partition = new MySqlPartition(sourceConfig.getMySqlConnectorConfig().getLogicalName());
    }

    public List<String> listNamespaces() {
        throw new UnsupportedOperationException("List namespace is not supported by MySQL.");
    }

    public List<String> listSchemas(@Nullable String namespace) {
        return MySqlSchemaUtils.listDatabases(this.sourceConfig);
    }

    public List<TableId> listTables(@Nullable String namespace, @Nullable String dbName) {
        return MySqlSchemaUtils.listTables(this.sourceConfig, dbName);
    }

    public Schema getTableSchema(TableId tableId) {
        return MySqlSchemaUtils.getTableSchema(this.sourceConfig, this.partition, tableId);
    }
}

