/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.util;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ItemRepo;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.crafting.v2.CraftingJobV2;
import appeng.integration.modules.NEI;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.me.cache.CraftingGridCache;
import appeng.util.Platform;
import codechicken.nei.recipe.StackInfo;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.client.gui.IGuiMonitorTerminal;
import com.asdflj.ae2thing.common.item.ItemBackpackTerminal;
import com.asdflj.ae2thing.common.item.ItemWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.util.Ae2Reflect;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.client.gui.FCGuiTextField;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import thaumicenergistics.common.integration.tc.AspectHooks;

public class Util {
    private static int AE_VERSION = -1;
    private static int randTickSeed = 0;

    public static int getAEVersion() {
        if (AE_VERSION == -1) {
            Optional<ModContainer> mod = Loader.instance().getActiveModList().stream().filter(x -> x.getModId().equals("appliedenergistics2")).findFirst();
            if (mod.isPresent()) {
                try {
                    AE_VERSION = Integer.parseInt(mod.get().getVersion().split("-")[2]);
                }
                catch (Exception ignored) {
                    AE_VERSION = 0;
                }
            } else {
                AE_VERSION = 0;
            }
        }
        return AE_VERSION;
    }

    public static boolean replan(EntityPlayer player, ContainerCraftConfirm c) {
        CraftingJobV2 jobV2;
        ICraftingJob job = Ae2Reflect.getJob(c);
        if (!(job instanceof CraftingJobV2) || !(jobV2 = (CraftingJobV2)job).isDone()) {
            return false;
        }
        c.simulation = true;
        c.bytesUsed = 0L;
        Object target = c.getTarget();
        if (target instanceof IGridHost) {
            IGridHost gh = (IGridHost)target;
            IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
            if (gn == null) {
                return false;
            }
            IGrid g = gn.getGrid();
            if (g == null || c.getItemToCraft() == null) {
                return false;
            }
            Future futureJob = null;
            try {
                Container container;
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                if (cg instanceof CraftingGridCache) {
                    CraftingGridCache cgc = (CraftingGridCache)cg;
                    futureJob = cgc.beginCraftingJob(c.getWorld(), g, c.getActionSource(), c.getItemToCraft(), null);
                }
                if ((container = player.field_71070_bA) instanceof ContainerCraftConfirm) {
                    ContainerCraftConfirm ccc = (ContainerCraftConfirm)container;
                    ccc.setJob(futureJob);
                    ccc.func_75142_b();
                }
                return true;
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug((Throwable)e);
            }
        }
        return false;
    }

    public static boolean isSameDimensionalCoord(DimensionalCoord a, DimensionalCoord b) {
        return a != null && b != null && a.x == b.x && a.y == b.y && a.z == b.z && a.getDimension() == b.getDimension();
    }

    public static int getPlayerID(EntityPlayer player) {
        GameProfile profile = player.func_146103_bH();
        return WorldData.instance().playerData().getPlayerID(profile);
    }

    public static int findBackPackTerminal(EntityPlayer player) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || item.func_77973_b() == null || !(item.func_77973_b() instanceof ItemBackpackTerminal)) continue;
            return x;
        }
        return -1;
    }

    public static int findDualInterfaceTerminal(EntityPlayer player) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || item.func_77973_b() == null || !(item.func_77973_b() instanceof ItemWirelessDualInterfaceTerminal)) continue;
            return x;
        }
        return -1;
    }

    public static IGrid getWirelessGrid(EntityPlayer player) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            IGridNode node;
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || item.func_77973_b() == null || (node = Util.getWirelessGridNode(item)) == null) continue;
            return node.getGrid();
        }
        return null;
    }

    public static String getModId(IAEItemStack item) {
        if (item.getItem() instanceof ItemFluidDrop) {
            FluidStack fs = ItemFluidDrop.getFluidStack((ItemStack)item.getItemStack());
            if (fs == null) {
                return GameRegistry.findUniqueIdentifierFor((Item)item.getItem()).modId;
            }
            if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((FluidStack)fs)) {
                ModContainer mod = AspectHooks.aspectToMod.getOrDefault(AspectUtil.getAspectFromGas((FluidStack)fs), null);
                if (mod != null) {
                    return mod.getModId();
                }
            } else {
                return Util.getFluidModID(fs.getFluid());
            }
        }
        return Platform.getModId((IAEItemStack)item);
    }

    public static String getFluidModID(Fluid fluid) {
        String name = FluidRegistry.getDefaultFluidName((Fluid)fluid);
        try {
            return name.split(":")[0];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isFluidPacket(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemFluidPacket;
    }

    @Nonnull
    public static String getDisplayName(IAEItemStack item) {
        FluidStack fs = StackInfo.getFluid((ItemStack)item.getItemStack());
        if (fs != null) {
            if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((FluidStack)fs)) {
                return AspectUtil.getAspectFromGas((FluidStack)fs).getName();
            }
            return fs.getLocalizedName();
        }
        return Platform.getItemDisplayName((Object)item);
    }

    public static IGridHost getWirelessGridHost(ItemStack is) {
        if (is.func_77973_b() instanceof ToolWirelessTerminal) {
            String key = ((ToolWirelessTerminal)is.func_77973_b()).getEncryptionKey(is);
            return (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(Long.parseLong(key));
        }
        return null;
    }

    public static IGridNode getWirelessGridNode(ItemStack is) {
        IGridHost host = Util.getWirelessGridHost(is);
        if (host == null) {
            return null;
        }
        return host.getGridNode(ForgeDirection.UNKNOWN);
    }

    public static int findItemStack(EntityPlayer player, ItemStack itemStack) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || !Platform.isSameItemPrecise((ItemStack)item, (ItemStack)itemStack)) continue;
            return x;
        }
        return -1;
    }

    public static long genSingularityFreq() {
        long freq = new Date().getTime() * 100L + (long)(randTickSeed % 100);
        ++randTickSeed;
        return freq;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null) {
            FluidStack fluid;
            if (stack.func_77973_b() instanceof IFluidContainerItem && (fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
            if (FluidContainerRegistry.isContainer((ItemStack)stack) && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
        }
        return null;
    }

    public static List<Integer> getBackpackSlot(EntityPlayer player) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || item.func_77973_b() == null || !AE2ThingAPI.instance().isBackpackItem(item)) continue;
            result.add(x);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getLimitFPS() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71474_y.field_74350_i;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getCurrentFPS() {
        try {
            Field field = Minecraft.class.getDeclaredField("debugFPS");
            field.setAccessible(true);
            return field.getInt(Minecraft.func_71410_x());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static IDisplayRepo getDisplayRepo(AEBaseGui gui) {
        if (gui instanceof IGuiMonitorTerminal) {
            IGuiMonitorTerminal gmt = (IGuiMonitorTerminal)gui;
            return gmt.getRepo();
        }
        return Util.getDisplayRepo(gui, gui.getClass());
    }

    public static void setSearchFieldText(AEBaseGui gui, String text) {
        String displayName = NEI.searchField.getEscapedSearchText(text);
        if (gui instanceof IGuiMonitorTerminal) {
            IGuiMonitorTerminal gmt = (IGuiMonitorTerminal)gui;
            gmt.getSearchField().func_146180_a(displayName);
            gmt.getRepo().setSearchString(displayName);
            gmt.getRepo().updateView();
        } else {
            IDisplayRepo repo = Util.getDisplayRepo(gui);
            if (repo != null) {
                Util.setSearchFieldText(gui, gui.getClass(), displayName);
                repo.setSearchString(displayName);
                repo.updateView();
            }
        }
    }

    private static void setSearchFieldText(AEBaseGui gui, Class<? extends AEBaseGui> clazz, String text) {
        try {
            if (clazz == AEBaseGui.class) {
                return;
            }
            for (Field f : clazz.getDeclaredFields()) {
                if (f.getType() == MEGuiTextField.class) {
                    f.setAccessible(true);
                    ((MEGuiTextField)f.get(gui)).setText(text);
                    return;
                }
                if (f.getType() != FCGuiTextField.class) continue;
                f.setAccessible(true);
                ((FCGuiTextField)f.get(gui)).func_146180_a(text);
                return;
            }
            Util.setSearchFieldText(gui, clazz.getSuperclass(), text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static IDisplayRepo getDisplayRepo(AEBaseGui gui, Class<? extends AEBaseGui> clazz) {
        try {
            if (clazz == AEBaseGui.class) {
                return null;
            }
            for (Field f : clazz.getDeclaredFields()) {
                if (f.getType() != IDisplayRepo.class && f.getType() != ItemRepo.class) continue;
                f.setAccessible(true);
                return (IDisplayRepo)f.get(gui);
            }
            return Util.getDisplayRepo(gui, clazz.getSuperclass());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class DimensionalCoordSide
    extends DimensionalCoord {
        private ForgeDirection side = ForgeDirection.UNKNOWN;
        private final String name;

        public DimensionalCoordSide(int _x, int _y, int _z, int _dim, ForgeDirection side, String name) {
            super(_x, _y, _z, _dim);
            this.side = side;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ForgeDirection getSide() {
            return this.side;
        }

        public void writeToNBT(NBTTagCompound data) {
            data.func_74768_a("side", this.side.ordinal());
            data.func_74778_a("name", this.name);
            super.writeToNBT(data);
        }

        public static DimensionalCoordSide readFromNBT(NBTTagCompound data) {
            return new DimensionalCoordSide(data.func_74762_e("x"), data.func_74762_e("y"), data.func_74762_e("z"), data.func_74762_e("dim"), ForgeDirection.getOrientation((int)data.func_74762_e("side")), data.func_74779_i("name"));
        }
    }
}

