/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import com.asdflj.ae2thing.util.FindITUtil;
import com.asdflj.ae2thing.util.StorageProvider;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class SPacketFindCellItem
implements IMessage {
    private List<StorageProvider> storageProviderList;

    public SPacketFindCellItem() {
    }

    public SPacketFindCellItem(List<StorageProvider> list) {
        this.storageProviderList = list;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(buf.readBytes(buf.readableBytes()).array());
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)bytes);
            this.storageProviderList = StorageProvider.readAsListFromNBT(tag);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        StorageProvider.writeListToNBT(tag, this.storageProviderList);
        try {
            ByteBuf data = Unpooled.buffer();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)outputStream);
            data.writeBytes(bytes.toByteArray());
            data.capacity(data.readableBytes());
            buf.writeBytes(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketFindCellItem, IMessage> {
        public IMessage onMessage(SPacketFindCellItem message, MessageContext ctx) {
            FindITUtil.instance.setSlotHighlighter(message.storageProviderList, true);
            return null;
        }
    }
}

