/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.container.AEBaseContainer;
import appeng.helpers.ICustomNameObject;
import appeng.tile.networking.TileCableBus;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.IClickableInTerminal;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.network.SPacketStringUpdate;
import com.asdflj.ae2thing.network.SPacketSwitchBack;
import com.asdflj.ae2thing.util.BlockPos;
import com.asdflj.ae2thing.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketRenamer
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int dim;
    private ForgeDirection side;
    private Action action;
    private String text;

    public CPacketRenamer() {
    }

    public CPacketRenamer(String text) {
        this.action = Action.SET_TEXT;
        this.text = text;
    }

    public CPacketRenamer(Action a) {
        this.action = a;
    }

    public CPacketRenamer(int x, int y, int z, int dim, ForgeDirection side) {
        this.action = Action.OPEN;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        if (this.action == Action.OPEN) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.dim = buf.readInt();
            this.side = ForgeDirection.getOrientation((int)buf.readInt());
        } else if (this.action == Action.SET_TEXT) {
            int leName = buf.readInt();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < leName; ++i) {
                sb.append(buf.readChar());
            }
            this.text = sb.toString();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        if (this.action == Action.OPEN) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.dim);
            buf.writeInt(this.side.ordinal());
        } else if (this.action == Action.SET_TEXT) {
            buf.writeInt(this.text.length());
            for (int i = 0; i < this.text.length(); ++i) {
                buf.writeChar((int)this.text.charAt(i));
            }
        }
    }

    public static enum Action {
        OPEN,
        GET_TEXT,
        SET_TEXT;

    }

    public static class Handler
    implements IMessageHandler<CPacketRenamer, IMessage> {
        private String getName(ICustomNameObject obj) {
            return obj.hasCustomName() ? obj.getCustomName() : "";
        }

        private String getName(TileEntity tile, ForgeDirection side) {
            if (tile instanceof TileCableBus) {
                return this.getName((ICustomNameObject)((TileCableBus)tile).getPart(side));
            }
            return this.getName((ICustomNameObject)tile);
        }

        private void setName(TileEntity tile, ForgeDirection side, String text) {
            if (tile instanceof TileCableBus) {
                ((ICustomNameObject)((TileCableBus)tile).getPart(side)).setCustomName(text);
            } else {
                ((ICustomNameObject)tile).setCustomName(text);
            }
        }

        public IMessage onMessage(CPacketRenamer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            AEBaseContainer con = (AEBaseContainer)player.field_71070_bA;
            switch (message.action) {
                case OPEN: {
                    Object object = con.getTarget();
                    if (!(object instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)object;
                    TileEntity tile = DimensionManager.getWorld((int)message.dim).func_147438_o(message.x, message.y, message.z);
                    if (!(tile instanceof ICustomNameObject)) break;
                    String name = this.getName(tile, message.side);
                    clickableInterface.setClickedInterface(new Util.DimensionalCoordSide(message.x, message.y, message.z, message.dim, message.side, name));
                    Object object2 = con.getTarget();
                    if (!(object2 instanceof WirelessTerminal)) break;
                    WirelessTerminal terminal = (WirelessTerminal)object2;
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(terminal.getInventorySlot(), 0, 0), message.side, GuiType.RENAMER);
                    break;
                }
                case GET_TEXT: {
                    Object tile = con.getTarget();
                    if (!(tile instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)tile;
                    Util.DimensionalCoordSide intMsg = clickableInterface.getClickedInterface();
                    TileEntity tile2 = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(intMsg.x, intMsg.y, intMsg.z);
                    AE2Thing.proxy.netHandler.sendTo(new SPacketStringUpdate(this.getName(tile2, intMsg.getSide())), player);
                    break;
                }
                case SET_TEXT: {
                    Object intMsg = con.getTarget();
                    if (!(intMsg instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)intMsg;
                    intMsg = clickableInterface.getClickedInterface();
                    TileEntity tile = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(((Util.DimensionalCoordSide)((Object)intMsg)).x, ((Util.DimensionalCoordSide)((Object)intMsg)).y, ((Util.DimensionalCoordSide)((Object)intMsg)).z);
                    this.setName(tile, ((Util.DimensionalCoordSide)((Object)intMsg)).getSide(), message.text);
                    AE2Thing.proxy.netHandler.sendTo(new SPacketSwitchBack(), player);
                }
            }
            return null;
        }
    }
}

