/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.container.ContainerOpenContext;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.slot.SlotFake;
import com.asdflj.ae2thing.client.gui.container.ContainerPatternValueAmount;
import com.asdflj.ae2thing.client.gui.container.IPatternValueContainer;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.util.BlockPos;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.common.item.ItemFluidPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class CPacketPatternValueSet
implements IMessage {
    private GuiType originGui;
    private int amount;
    private int valueIndex;

    public CPacketPatternValueSet() {
    }

    public CPacketPatternValueSet(int originalGui, int amount, int valueIndex) {
        this.originGui = GuiType.getByOrdinal(originalGui);
        this.amount = amount;
        this.valueIndex = valueIndex;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.originGui.ordinal());
        buf.writeInt(this.amount);
        buf.writeInt(this.valueIndex);
    }

    public void fromBytes(ByteBuf buf) {
        this.originGui = GuiType.getByOrdinal(buf.readInt());
        this.amount = buf.readInt();
        this.valueIndex = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<CPacketPatternValueSet, IMessage> {
        public IMessage onMessage(CPacketPatternValueSet message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerPatternValueAmount) {
                ContainerPatternValueAmount cpv = (ContainerPatternValueAmount)container;
                Object target = cpv.getTarget();
                ContainerOpenContext context = cpv.getOpenContext();
                if (context != null) {
                    Slot slot;
                    TileEntity te = context.getTile();
                    if (te != null) {
                        InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), message.originGui);
                    } else {
                        InventoryHandler.openGui((EntityPlayer)player, player.func_130014_f_(), new BlockPos(((IInventorySlotAware)target).getInventorySlot(), 0, 0), Objects.requireNonNull(context.getSide()), message.originGui);
                    }
                    if (player.field_71070_bA instanceof IPatternValueContainer && (slot = player.field_71070_bA.func_75139_a(message.valueIndex)) instanceof SlotFake) {
                        ItemStack stack = slot.func_75211_c().func_77946_l();
                        if (Util.isFluidPacket(stack)) {
                            FluidStack fluidStack = ItemFluidPacket.getFluidStack((ItemStack)stack);
                            if (fluidStack != null) {
                                fluidStack = Objects.requireNonNull(ItemFluidPacket.getFluidStack((ItemStack)stack)).copy();
                                fluidStack.amount = message.amount;
                            }
                            slot.func_75215_d(ItemFluidPacket.newStack((FluidStack)fluidStack));
                        } else {
                            stack.field_77994_a = message.amount;
                            slot.func_75215_d(stack);
                        }
                    }
                }
            }
            return null;
        }
    }
}

