/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.loader;

import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.network.wrapper.AE2ThingNetworkWrapper;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.world.World;

public class ChannelLoader
implements Runnable {
    public static final ChannelLoader INSTANCE = new ChannelLoader();

    public static Set<Class<?>> getClasses(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        LinkedHashSet classes = new LinkedHashSet();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (!"jar".equals(resource.getProtocol())) continue;
            ChannelLoader.processJarFile(classes, resource, packageName);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJarFile(Set<Class<?>> classes, URL jarFileUrl, String packageName) {
        ZipFile jarFile = null;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)jarFileUrl.openConnection();
            if (jarURLConnection != null && (jarFile = jarURLConnection.getJarFile()) != null) {
                Enumeration<JarEntry> jarEntries = ((JarFile)jarFile).entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.startsWith(packageName.replace('.', '/') + '/') || !jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    try {
                        classes.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void run() {
        int id = 0;
        AE2ThingNetworkWrapper netHandler = AE2Thing.proxy.netHandler;
        try {
            Set<Class<?>> result = ChannelLoader.getClasses("com.asdflj.ae2thing.network");
            for (Class<?> aClass : result) {
                if (!aClass.getName().endsWith("Handler")) continue;
                Class<?> c = Class.forName(aClass.getName().replace("$Handler", ""));
                IMessageHandler cls = (IMessageHandler)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                netHandler.registerMessage(cls, c, id++, c.getSimpleName().startsWith("C") ? Side.SERVER : Side.CLIENT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendPacketToAllPlayers(Packet packet, World world) {
        for (Object player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }
}

