/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.inventory.item;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.asdflj.ae2thing.api.WirelessObject;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.asdflj.ae2thing.inventory.ItemBiggerAppEngInventory;
import com.asdflj.ae2thing.inventory.ItemPatternRefillInventory;
import com.asdflj.ae2thing.inventory.ItemPatternsInventory;
import com.asdflj.ae2thing.inventory.item.IClickableInTerminal;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class WirelessDualInterfaceTerminalInventory
extends WirelessTerminal
implements IGridHost,
IPatternTerminal,
IClickableInTerminal,
IAEAppEngInventory {
    protected AppEngInternalInventory craftingEx;
    protected AppEngInternalInventory outputEx;
    protected AppEngInternalInventory pattern;
    protected AppEngInternalInventory upgrades;
    protected AppEngInternalInventory crafting;
    protected boolean craftingMode = false;
    protected boolean substitute = false;
    protected boolean combine = false;
    protected boolean prioritize = false;
    protected boolean inverted = false;
    protected boolean beSubstitute = false;
    protected int activePage = 0;
    private Util.DimensionalCoordSide tile;

    public WirelessDualInterfaceTerminalInventory(WirelessObject obj) {
        super(obj);
        this.pattern = new ItemPatternsInventory(obj.getItemStack(), this, obj.getPlayer(), obj.getSlot());
        this.crafting = new ItemBiggerAppEngInventory(obj.getItemStack(), "crafting", 9, obj.getPlayer(), obj.getSlot(), this);
        this.craftingEx = new ItemBiggerAppEngInventory(obj.getItemStack(), "crafting_ex", 32, obj.getPlayer(), obj.getSlot());
        this.outputEx = new ItemBiggerAppEngInventory(obj.getItemStack(), "output_ex", 32, obj.getPlayer(), obj.getSlot());
        this.upgrades = new ItemPatternRefillInventory(obj.getItemStack(), "upgrades", 1, 1, obj.getPlayer(), obj.getSlot());
        this.readFromNBT();
    }

    private void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.obj.getItemStack());
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCombineMode(data.func_74767_n("combine"));
        this.setBeSubstitute(data.func_74767_n("beSubstitute"));
        this.setPrioritization(data.func_74767_n("priorization"));
        this.setInverted(data.func_74767_n("inverted"));
        this.setActivePage(data.func_74762_e("activePage"));
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        if (data.func_74764_b("clickedInterface")) {
            NBTTagCompound tileMsg = (NBTTagCompound)data.func_74781_a("clickedInterface");
            this.tile = Util.DimensionalCoordSide.readFromNBT(tileMsg);
        }
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)this.getItemStack());
            manager.writeToNBT(data);
            this.saveSettings();
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData((ItemStack)this.getItemStack()).func_74737_b());
        return out;
    }

    @Override
    public IGridNode getActionableNode() {
        return this.obj.getGridNode();
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.obj.getGridNode();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return null;
    }

    @Override
    public void securityBreak() {
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting_ex")) {
            return this.craftingEx;
        }
        if (name.equals("output_ex")) {
            return this.outputEx;
        }
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public void setActivePage(int value) {
        this.activePage = value;
    }

    @Override
    public int getActivePage() {
        return this.activePage;
    }

    @Override
    public boolean shouldCombine() {
        return this.combine;
    }

    @Override
    public void setCombineMode(boolean shouldCombine) {
        this.combine = shouldCombine;
    }

    @Override
    public void setPrioritization(boolean canPrioritize) {
        this.prioritize = canPrioritize;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    @Override
    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public void setBeSubstitute(boolean canBeSubstitute) {
        this.beSubstitute = canBeSubstitute;
    }

    @Override
    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public boolean canBeSubstitute() {
        return this.beSubstitute;
    }

    @Override
    public boolean isPrioritize() {
        return this.prioritize;
    }

    @Override
    public boolean isSubstitution() {
        return this.substitute;
    }

    @Override
    public void sortCraftingItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        ArrayList<Object> fluids = new ArrayList<Object>();
        for (ItemStack is : this.craftingEx) {
            if (is == null) continue;
            if (is.func_77973_b() instanceof ItemFluidPacket) {
                fluids.add(is);
                continue;
            }
            items.add(is);
        }
        if (this.prioritize) {
            fluids.addAll(items);
            items.clear();
        } else {
            items.addAll(fluids);
            fluids.clear();
        }
        for (int i = 0; i < this.craftingEx.func_70302_i_() && this.craftingEx.func_70301_a(i) != null; ++i) {
            if (items.isEmpty()) {
                this.craftingEx.func_70299_a(i, (ItemStack)fluids.get(i));
                continue;
            }
            this.craftingEx.func_70299_a(i, (ItemStack)items.get(i));
        }
    }

    @Override
    public void saveSettings() {
        this.writeToNBT();
    }

    @Override
    public boolean hasRefillerUpgrade() {
        return this.upgrades.func_70301_a(0) != null;
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem craftingPatternItem;
        ICraftingPatternDetails details;
        Item item;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && (item = is.func_77973_b()) instanceof ICraftingPatternItem && (details = (craftingPatternItem = (ICraftingPatternItem)item).getPatternForItem(is, this.getActionableNode().getWorld())) != null) {
            int i;
            IAEItemStack[] inItems = details.getInputs();
            IAEItemStack[] outItems = details.getOutputs();
            this.setCraftingRecipe(details.isCraftable());
            int inputsCount = 0;
            int outputCount = 0;
            for (IAEItemStack inItem : inItems) {
                if (inItem == null) continue;
                ++inputsCount;
            }
            for (IAEItemStack outItem : outItems) {
                if (outItem == null) continue;
                ++outputCount;
            }
            this.setSubstitution(details.canSubstitute());
            if (newStack != null) {
                this.setBeSubstitute(details.canBeSubstitute());
            }
            this.setInverted(inputsCount <= 8 && outputCount > 8);
            this.setActivePage(0);
            for (i = 0; i < this.craftingEx.func_70302_i_(); ++i) {
                this.craftingEx.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.outputEx.func_70302_i_(); ++i) {
                this.outputEx.func_70299_a(i, null);
            }
            for (i = 0; i < this.getCraftingInternalInventory().func_70302_i_() && i < inItems.length; ++i) {
                IAEItemStack item2 = inItems[i];
                if (item2 == null) continue;
                if (item2.getItem() instanceof ItemFluidDrop && !this.isCraftingRecipe()) {
                    ItemStack packet = ItemFluidPacket.newStack((FluidStack)ItemFluidDrop.getFluidStack((ItemStack)item2.getItemStack()));
                    this.getCraftingInternalInventory().func_70299_a(i, packet);
                    continue;
                }
                this.getCraftingInternalInventory().func_70299_a(i, item2.getItemStack());
            }
            if (this.inverted) {
                for (i = 0; i < this.outputEx.func_70302_i_() && i < outItems.length; ++i) {
                    IAEItemStack item3 = outItems[i];
                    if (item3 == null) continue;
                    if (item3.getItem() instanceof ItemFluidDrop) {
                        ItemStack packet = ItemFluidPacket.newStack((FluidStack)ItemFluidDrop.getFluidStack((ItemStack)item3.getItemStack()));
                        this.outputEx.func_70299_a(i, packet);
                        continue;
                    }
                    this.outputEx.func_70299_a(i, item3.getItemStack());
                }
            } else {
                for (i = 0; i < outItems.length && i < 8; ++i) {
                    IAEItemStack item4 = outItems[i];
                    if (item4 == null) continue;
                    if (item4.getItem() instanceof ItemFluidDrop) {
                        ItemStack packet = ItemFluidPacket.newStack((FluidStack)ItemFluidDrop.getFluidStack((ItemStack)item4.getItemStack()));
                        this.outputEx.func_70299_a(i >= 4 ? 12 + i : i, packet);
                        continue;
                    }
                    this.outputEx.func_70299_a(i >= 4 ? 12 + i : i, item4.getItemStack());
                }
            }
        }
        if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
    }

    private AppEngInternalInventory getCraftingInternalInventory() {
        return this.isCraftingRecipe() ? this.crafting : this.craftingEx;
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
                ItemStack is = this.crafting.func_70301_a(x);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
    }

    private void writeToNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.getItemStack());
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("combine", this.combine);
        data.func_74757_a("beSubstitute", this.beSubstitute);
        data.func_74757_a("priorization", this.prioritize);
        data.func_74757_a("inverted", this.inverted);
        data.func_74768_a("activePage", this.activePage);
        this.craftingEx.func_70296_d();
        this.outputEx.func_70296_d();
        this.upgrades.func_70296_d();
        this.pattern.func_70296_d();
        this.crafting.func_70296_d();
        NBTTagCompound tileMsg = new NBTTagCompound();
        if (this.tile != null) {
            this.tile.writeToNBT(tileMsg);
        }
        data.func_74782_a("clickedInterface", (NBTBase)tileMsg);
    }

    @Override
    public void setClickedInterface(Util.DimensionalCoordSide tile) {
        this.tile = tile;
        this.writeToNBT();
    }

    @Override
    public Util.DimensionalCoordSide getClickedInterface() {
        return this.tile;
    }
}

