/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.inventory;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.asdflj.ae2thing.common.tile.TileInfusionInterface;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class EssentiaInventoryAdaptor
extends InventoryAdaptor {
    private final InventoryAdaptor adaptor;
    private final TileInfusionInterface tile;

    public EssentiaInventoryAdaptor(InventoryAdaptor ad, TileInfusionInterface tile) {
        this.adaptor = ad;
        this.tile = tile;
    }

    public static InventoryAdaptor getAdaptor(TileEntity tile, ForgeDirection d) {
        InventoryAdaptor ad = InventoryAdaptor.getAdaptor((Object)tile, (ForgeDirection)d);
        if (ad == null) {
            return null;
        }
        TileEntity inter = tile.func_145831_w().func_147438_o(tile.field_145851_c + d.offsetX, tile.field_145848_d + d.offsetY, tile.field_145849_e + d.offsetZ);
        if (inter instanceof TileInfusionInterface) {
            TileInfusionInterface t = (TileInfusionInterface)inter;
            return new EssentiaInventoryAdaptor(ad, t);
        }
        return ad;
    }

    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.adaptor.removeItems(amount, filter, destination);
    }

    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.adaptor.simulateRemove(amount, filter, destination);
    }

    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.adaptor.removeSimilarItems(amount, filter, fuzzyMode, destination);
    }

    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.adaptor.simulateSimilarRemove(amount, filter, fuzzyMode, destination);
    }

    public ItemStack addItems(ItemStack toBeAdded) {
        if (toBeAdded.func_77973_b() instanceof ItemPhial) {
            return this.tile.addAspects(toBeAdded);
        }
        return this.adaptor.addItems(toBeAdded);
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.adaptor.simulateAdd(toBeSimulated);
    }

    public boolean containsItems() {
        return this.adaptor.containsItems();
    }

    @NotNull
    public Iterator<ItemSlot> iterator() {
        return this.adaptor.iterator();
    }
}

