/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.cache.CraftingGridCache;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkTile;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;

public class TileEssentiaDiscretizer
extends AENetworkTile
implements IPriorityHost,
ICellContainer {
    private final BaseActionSource ownActionSource = new MachineSource((IActionHost)this);
    private final FluidDiscretizingInventory fluidDropInv = new FluidDiscretizingInventory();
    private final FluidCraftingInventory fluidCraftInv = new FluidCraftingInventory();
    private boolean prevActiveState = false;

    public TileEssentiaDiscretizer() {
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public boolean canBeRotated() {
        return false;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            if (channel == StorageChannel.ITEMS) {
                return Collections.singletonList(this.fluidDropInv.invHandler);
            }
            if (channel == StorageChannel.FLUIDS) {
                return Collections.singletonList(this.fluidCraftInv.invHandler);
            }
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void setPriority(int newValue) {
    }

    public void blinkCell(int slot) {
    }

    public void gridChanged() {
        IMEMonitor<IAEFluidStack> fluidGrid = this.getFluidGrid();
        if (fluidGrid != null) {
            fluidGrid.addListener((IMEMonitorHandlerReceiver)this.fluidDropInv, fluidGrid);
        }
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.func_70296_d();
    }

    private IMEMonitor<IAEFluidStack> getFluidGrid() {
        try {
            return ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getFluidInventory();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    private IEnergyGrid getEnergyGrid() {
        try {
            return (IEnergyGrid)this.getProxy().getGrid().getCache(IEnergyGrid.class);
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    private void updateState() {
        boolean isActive = this.getProxy().isActive();
        if (isActive != this.prevActiveState) {
            this.prevActiveState = isActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @MENetworkEventSubscribe
    public void onPowerUpdate(MENetworkPowerStatusChange event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onChannelUpdate(MENetworkChannelsChanged event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onStorageUpdate(MENetworkStorageEvent event) {
        this.updateState();
    }

    private class FluidDiscretizingInventory
    implements IMEInventory<IAEItemStack>,
    IMEMonitorHandlerReceiver<IAEFluidStack> {
        private final MEInventoryHandler<IAEItemStack> invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());
        private IItemList<IAEItemStack> itemCache = null;

        FluidDiscretizingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        public IAEItemStack injectItems(IAEItemStack request, Actionable type, BaseActionSource src) {
            Aspect aspect = ItemPhial.getAspect(request);
            if (aspect == null) {
                return request;
            }
            IMEMonitor fluidGrid = TileEssentiaDiscretizer.this.getFluidGrid();
            if (fluidGrid == null) {
                return request;
            }
            IEnergyGrid energyGrid = TileEssentiaDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return request;
            }
            return ItemPhial.newAeStack((IAEFluidStack)fluidGrid.injectItems((IAEStack)ItemPhial.newEssentiaStack(aspect, request.getStackSize()), type, src));
        }

        public IAEItemStack extractItems(IAEItemStack request, Actionable type, BaseActionSource src) {
            Aspect aspect = ItemPhial.getAspect(request);
            if (aspect == null) {
                return null;
            }
            IMEMonitor fluidGrid = TileEssentiaDiscretizer.this.getFluidGrid();
            if (fluidGrid == null) {
                return null;
            }
            IEnergyGrid energyGrid = TileEssentiaDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return null;
            }
            return ItemPhial.newAeStack((IAEFluidStack)fluidGrid.extractItems((IAEStack)ItemPhial.newEssentiaStack(aspect, request.getStackSize()), type, src));
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            if (this.itemCache == null) {
                this.itemCache = AEApi.instance().storage().createItemList();
                IMEMonitor fluidGrid = TileEssentiaDiscretizer.this.getFluidGrid();
                if (fluidGrid != null) {
                    for (IAEFluidStack fluid : fluidGrid.getStorageList()) {
                        IAEItemStack stack = ItemPhial.newAeStack(fluid);
                        if (stack == null) continue;
                        this.itemCache.add((IAEStack)stack);
                    }
                }
            }
            for (IAEItemStack stack : this.itemCache) {
                out.addStorage((IAEStack)stack);
            }
            return out;
        }

        public IAEItemStack getAvailableItem(@Nonnull IAEItemStack request) {
            IMEMonitor fluidGrid = TileEssentiaDiscretizer.this.getFluidGrid();
            if (fluidGrid == null) {
                return null;
            }
            IAEFluidStack fluidRequest = ItemPhial.getAeEssentiaStack(request);
            if (fluidRequest == null) {
                return null;
            }
            IAEFluidStack availableFluid = (IAEFluidStack)fluidGrid.getAvailableItem((IAEStack)fluidRequest);
            if (availableFluid == null || availableFluid.getFluid() == null) {
                return null;
            }
            return ItemPhial.newAeStack(availableFluid);
        }

        public StorageChannel getChannel() {
            return StorageChannel.ITEMS;
        }

        public boolean isValid(Object verificationToken) {
            IMEMonitor fluidGrid = TileEssentiaDiscretizer.this.getFluidGrid();
            return fluidGrid != null && fluidGrid == verificationToken;
        }

        public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
            this.itemCache = null;
            try {
                ArrayList<IAEItemStack> mappedChanges = new ArrayList<IAEItemStack>();
                for (IAEFluidStack fluidStack : change) {
                    IAEItemStack itemStack = ItemPhial.newAeStack(fluidStack);
                    if (itemStack == null) continue;
                    mappedChanges.add(itemStack);
                }
                ((IStorageGrid)TileEssentiaDiscretizer.this.getProxy().getGrid().getCache(IStorageGrid.class)).postAlterationOfStoredItems(this.getChannel(), mappedChanges, TileEssentiaDiscretizer.this.ownActionSource);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }

        public void onListUpdate() {
        }
    }

    private class FluidCraftingInventory
    implements IMEInventory<IAEFluidStack> {
        private final MEInventoryHandler<IAEFluidStack> invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());

        FluidCraftingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
            IAEStack remaining;
            ICraftingGrid craftingGrid;
            try {
                craftingGrid = (ICraftingGrid)TileEssentiaDiscretizer.this.getProxy().getGrid().getCache(ICraftingGrid.class);
            }
            catch (GridAccessException e) {
                return null;
            }
            if (craftingGrid instanceof CraftingGridCache && AspectUtil.isEssentiaGas((FluidStack)input.getFluidStack()) && (remaining = ((CraftingGridCache)craftingGrid).injectItems((IAEStack)ItemPhial.newAeStack(input), type, TileEssentiaDiscretizer.this.ownActionSource)) instanceof IAEItemStack) {
                return ItemPhial.getAeEssentiaStack((IAEItemStack)remaining);
            }
            return input;
        }

        public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
            return null;
        }

        public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
            return out;
        }

        public IAEFluidStack getAvailableItem(@Nonnull IAEFluidStack request) {
            return null;
        }

        public StorageChannel getChannel() {
            return StorageChannel.FLUIDS;
        }
    }
}

