/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage.infinityCell;

import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.DataStorage;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventory;
import com.glodblock.github.common.storage.IStorageFluidCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InfinityFluidStorageCellInventory
implements ITFluidCellInventory {
    protected static final String FLUID_TYPE_TAG = "ft";
    protected static final String FLUID_COUNT_TAG = "fc";
    private final IChestOrDrive drive;
    protected IStorageFluidCell cellType;
    protected final ItemStack cellItem;
    protected final ISaveProvider container;
    protected long storedFluidCount;
    protected long storedFluids;
    protected IItemList<IAEFluidStack> cellFluids = null;
    protected final NBTTagCompound data;
    protected final DataStorage storage;

    public InfinityFluidStorageCellInventory(ItemStack o, ISaveProvider c, EntityPlayer player) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.drive = c instanceof IChestOrDrive ? (IChestOrDrive)c : null;
        this.cellItem = o;
        this.cellType = (IStorageFluidCell)this.cellItem.func_77973_b();
        this.container = c;
        this.data = Platform.openNbtData((ItemStack)o);
        this.storedFluids = this.data.func_74763_f(FLUID_TYPE_TAG);
        this.storedFluidCount = this.data.func_74763_f(FLUID_COUNT_TAG);
        this.storage = this.getStorage();
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        IAEFluidStack l = (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)input);
        if (l != null) {
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewFluid()) {
            if (mode == Actionable.MODULATE) {
                this.cellFluids.add((IAEStack)input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = request.getStackSize();
        IAEFluidStack results = null;
        IAEFluidStack l = (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return results;
    }

    private void saveChanges() {
        this.data.func_74757_a("is_empty", this.cellFluids.isEmpty());
        if (this.container != null) {
            this.container.saveChanges((IMEInventory)this);
        }
        AE2ThingAPI.instance().getStorageManager().postChanges(this.cellItem, this.storage, this.drive);
        AE2ThingAPI.instance().getStorageManager().func_76186_a(true);
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        AE2ThingAPI.instance().getStorageManager().addGrid(this.getUUID(), this.drive);
        for (IAEFluidStack i : this.getCellFluids()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    protected IItemList<IAEFluidStack> getCellFluids() {
        if (this.cellFluids == null) {
            this.loadCellFluids();
        }
        return this.cellFluids;
    }

    protected void loadCellFluids() {
        if (this.cellFluids == null) {
            this.cellFluids = this.storage.getFluids();
            for (IAEFluidStack is : this.cellFluids) {
                if (is.getStackSize() > 0L) continue;
                is.reset();
            }
        }
        if (!this.getUUID().equals(this.storage.getUUID())) {
            this.data.func_74778_a("diskuuid", this.storage.getUUID());
        }
    }

    @Override
    public String getUUID() {
        if (this.data.func_82582_d()) {
            return "";
        }
        return this.data.func_74779_i("diskuuid");
    }

    public StorageChannel getChannel() {
        return ((BaseCellItem)Objects.requireNonNull(this.cellItem.func_77973_b())).getChannel();
    }

    public ItemStack getItemStack() {
        return this.cellItem;
    }

    public double getIdleDrain(ItemStack is) {
        return this.cellType.getIdleDrain(is);
    }

    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    public boolean canHoldNewFluid() {
        return true;
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.cellItem);
    }

    public long getFreeBytes() {
        return Integer.MAX_VALUE;
    }

    public long getUsedBytes() {
        return 0L;
    }

    public long getStoredFluidCount() {
        return this.storedFluidCount;
    }

    public long getRemainingFluidCount() {
        return Integer.MAX_VALUE;
    }

    public long getRemainingFluidTypes() {
        return Integer.MAX_VALUE;
    }

    public int getUnusedFluidCount() {
        return Integer.MAX_VALUE;
    }

    public int getStatusForCell() {
        if (this.canHoldNewFluid()) {
            return 1;
        }
        if (this.getRemainingFluidCount() > 0L) {
            return 2;
        }
        return 3;
    }

    public long getStoredFluidTypes() {
        return this.storedFluids;
    }

    public long getTotalFluidTypes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    public List<IAEFluidStack> getContents() {
        if (Platform.isClient()) {
            return Collections.emptyList();
        }
        ArrayList<IAEFluidStack> ret = new ArrayList<IAEFluidStack>();
        for (IAEFluidStack fluid : this.getCellFluids()) {
            ret.add(fluid);
        }
        return ret;
    }

    public IAEFluidStack getAvailableItem(@Nonnull IAEFluidStack request) {
        return (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)request);
    }

    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }
}

