/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage.infinityCell;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventory;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CreativeFluidCellInventory
implements ITFluidCellInventory {
    protected IStorageFluidCell cellType;
    protected final ItemStack cellItem;
    protected final ISaveProvider container;
    protected IItemList<IAEFluidStack> cellFluids = null;

    public CreativeFluidCellInventory(ItemStack o, ISaveProvider c, EntityPlayer player) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellItem = o;
        this.cellType = (IStorageFluidCell)this.cellItem.func_77973_b();
        this.container = c;
    }

    public ItemStack getItemStack() {
        return this.cellItem;
    }

    public double getIdleDrain(ItemStack is) {
        return this.cellType.getIdleDrain(is);
    }

    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    public boolean canHoldNewFluid() {
        return false;
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.cellItem);
    }

    public long getFreeBytes() {
        return 0L;
    }

    public long getUsedBytes() {
        return 0L;
    }

    public long getStoredFluidCount() {
        return 0L;
    }

    public long getRemainingFluidCount() {
        return 0L;
    }

    public long getRemainingFluidTypes() {
        return 0L;
    }

    public int getUnusedFluidCount() {
        return 0;
    }

    public int getStatusForCell() {
        if (this.canHoldNewFluid()) {
            return 1;
        }
        if (this.getRemainingFluidCount() > 0L) {
            return 2;
        }
        return 3;
    }

    public long getStoredFluidTypes() {
        return 1L;
    }

    public long getTotalFluidTypes() {
        return 1L;
    }

    public List<IAEFluidStack> getContents() {
        ArrayList<IAEFluidStack> ret = new ArrayList<IAEFluidStack>();
        for (IAEFluidStack fluid : this.getCellFluids()) {
            ret.add(fluid);
        }
        return ret;
    }

    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        if (this.getCellFluids().findPrecise((IAEStack)input) != null) {
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        if (this.getCellFluids().findPrecise((IAEStack)request) != null) {
            return request.copy();
        }
        return null;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        for (IAEFluidStack i : this.getCellFluids()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    protected IItemList<IAEFluidStack> getCellFluids() {
        if (this.cellFluids == null) {
            this.loadCellFluids();
        }
        return this.cellFluids;
    }

    protected void loadCellFluids() {
        if (this.cellFluids == null) {
            this.cellFluids = AEApi.instance().storage().createFluidList();
        }
        this.cellFluids.resetStatus();
        IInventory inv = this.cellType.getConfigInventory(this.cellItem);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            IAEFluidStack iaeFluidStack;
            FluidStack fs;
            ItemStack is = inv.func_70301_a(i);
            if (!Util.FluidUtil.isFluidContainer((ItemStack)is) || (fs = Util.getFluidFromItem((ItemStack)is)) == null || this.cellFluids.findPrecise((IAEStack)(iaeFluidStack = Util.FluidUtil.createAEFluidStack((FluidStack)fs))) != null) continue;
            iaeFluidStack.setStackSize(2147483647000L);
            this.cellFluids.add((IAEStack)iaeFluidStack);
        }
    }

    public StorageChannel getChannel() {
        return ((BaseCellItem)Objects.requireNonNull(this.cellItem.func_77973_b())).getChannel();
    }
}

