/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.IGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.StorageChannel;
import appeng.tile.grid.AENetworkInvTile;
import appeng.util.Platform;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.DataStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class StorageManager
extends WorldSavedData {
    private final Map<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();
    private final Map<UUID, Set<IGrid>> grids = new HashMap<UUID, Set<IGrid>>();

    public StorageManager(String name) {
        super(name);
        this.func_76186_a(true);
        AE2ThingAPI.instance().setStorageManager(this);
    }

    private DataStorage getStorage(String uuid, StorageChannel channel) {
        UUID uid;
        try {
            uid = UUID.fromString(uuid);
        }
        catch (Exception ignored) {
            while (this.disks.get(uid = UUID.randomUUID()) != null) {
            }
        }
        DataStorage d = this.disks.get(uid);
        if (d == null) {
            d = new DataStorage(uid, channel);
            this.disks.put(uid, d);
        }
        return d;
    }

    private void addGrid(UUID uid, IGrid grid) {
        if (!Config.cellLink || grid == null || grid.isEmpty()) {
            return;
        }
        this.grids.putIfAbsent(uid, new HashSet());
        this.grids.get(uid).add(grid);
    }

    public void addGrid(String uuid, IGrid grid) {
        UUID uid = UUID.fromString(uuid);
        this.addGrid(uid, grid);
    }

    public void addGrid(String uuid, IChestOrDrive drive) {
        if (drive == null || uuid.isEmpty()) {
            return;
        }
        this.addGrid(uuid, drive.getActionableNode().getGrid());
    }

    public DataStorage getStorage(ItemStack item) {
        Item item2 = item.func_77973_b();
        if (item2 instanceof BaseCellItem) {
            BaseCellItem bci = (BaseCellItem)item2;
            NBTTagCompound data = Platform.openNbtData((ItemStack)item);
            return this.getStorage(data.func_74779_i("diskuuid"), bci.getChannel());
        }
        return null;
    }

    public DataStorage getStorage(ItemStack item, EntityPlayer player) {
        DataStorage storage = this.getStorage(item);
        if (storage == null) {
            return null;
        }
        NBTTagCompound data = Platform.openNbtData((ItemStack)item);
        String uuid = data.func_74779_i("diskuuid");
        if (uuid.isEmpty()) {
            data.func_74778_a("diskuuid", storage.getUUID());
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, item.func_77946_l());
        }
        return storage;
    }

    public void setStorage(String uuid, ItemStack item) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)item);
        if (!data.func_74767_n("linked") && !this.getStorage(item).isEmpty()) {
            return;
        }
        String curUid = data.func_74779_i("diskuuid");
        if (!curUid.isEmpty() && curUid.equals(uuid)) {
            return;
        }
        data.func_74778_a("diskuuid", uuid);
        data.func_74757_a("linked", true);
    }

    public void func_76184_a(NBTTagCompound data) {
        HashMap<UUID, DataStorage> d = new HashMap<UUID, DataStorage>();
        NBTTagList diskList = data.func_150295_c("disklist", 10);
        for (int i = 0; i < diskList.func_74745_c(); ++i) {
            NBTTagCompound disk = diskList.func_150305_b(i);
            UUID uid = UUID.fromString(disk.func_74779_i("diskuuid"));
            d.put(uid, DataStorage.readFromNBT(uid, disk.func_150295_c("diskdata", 10), StorageChannel.ITEMS));
        }
        NBTTagList fluidDiskList = data.func_150295_c("fluid_disklist", 10);
        for (int i = 0; i < fluidDiskList.func_74745_c(); ++i) {
            NBTTagCompound disk = fluidDiskList.func_150305_b(i);
            UUID uid = UUID.fromString(disk.func_74779_i("diskuuid"));
            d.put(uid, DataStorage.readFromNBT(uid, disk.func_150295_c("fluid_disklist", 10), StorageChannel.FLUIDS));
        }
        this.disks.clear();
        this.disks.putAll(d);
    }

    public void func_76187_b(NBTTagCompound data) {
        NBTTagList diskList = new NBTTagList();
        NBTTagList fluidDiskList = new NBTTagList();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            NBTTagCompound disk = new NBTTagCompound();
            disk.func_74778_a("diskuuid", entry.getKey().toString());
            if (entry.getValue().getChannel() == StorageChannel.ITEMS) {
                disk.func_74782_a("diskdata", entry.getValue().writeToNBT());
                diskList.func_74742_a((NBTBase)disk);
                continue;
            }
            disk.func_74782_a("fluid_disklist", entry.getValue().writeToNBT());
            fluidDiskList.func_74742_a((NBTBase)disk);
        }
        data.func_74782_a("disklist", (NBTBase)diskList);
        data.func_74782_a("fluid_disklist", (NBTBase)fluidDiskList);
    }

    public void postChanges(ItemStack cell, DataStorage storage, IChestOrDrive drive) {
        if (!Config.cellLink || drive == null) {
            return;
        }
        if (drive instanceof AENetworkInvTile) {
            AENetworkInvTile ait = (AENetworkInvTile)drive;
            try {
                IGrid curGrid = ait.getProxy().getGrid();
                UUID uid = storage.getRawUUID();
                if (curGrid.isEmpty()) {
                    return;
                }
                Set<IGrid> iGrids = this.grids.get(uid);
                if (iGrids == null) {
                    return;
                }
                iGrids.removeIf(g -> g.isEmpty() || !g.getPivot().isActive());
                if (iGrids.size() <= 1) {
                    return;
                }
                iGrids.removeIf(i -> i == curGrid);
                ArrayList<IGrid> cp = new ArrayList<IGrid>(iGrids);
                for (IGrid grid : cp) {
                    if (grid.isEmpty() || grid.equals(curGrid)) continue;
                    IStorageGrid iStorageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    if (storage.getChannel() == StorageChannel.ITEMS) {
                        iStorageGrid.postAlterationOfStoredItems(storage.getChannel(), storage.getItems(), null);
                        continue;
                    }
                    if (storage.getChannel() != StorageChannel.FLUIDS) continue;
                    iStorageGrid.postAlterationOfStoredItems(storage.getChannel(), storage.getFluids(), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

