/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import com.asdflj.ae2thing.common.storage.CellInventory;
import com.asdflj.ae2thing.common.storage.ICellInventoryHandler;
import com.asdflj.ae2thing.common.storage.ITCellInventory;
import com.asdflj.ae2thing.util.Ae2Reflect;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CellInventoryHandler
extends MEInventoryHandler<IAEItemStack>
implements ICellInventoryHandler,
ICellCacheRegistry {
    public CellInventoryHandler(IMEInventory<IAEItemStack> i) {
        super(i, StorageChannel.ITEMS);
        ITCellInventory ci = this.getCellInv();
        if (ci instanceof CellInventory) {
            return;
        }
        this.init(ci);
    }

    public void init(ITCellInventory ci) {
        if (ci != null) {
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            String filter = ci.getOreFilter();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasOreFilter = false;
            boolean hasSticky = false;
            block6: for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block6;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block6;
                    }
                    case ORE_FILTER: {
                        hasOreFilter = true;
                        continue block6;
                    }
                    case STICKY: {
                        hasSticky = true;
                        continue block6;
                    }
                }
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (hasSticky) {
                this.setSticky(true);
            }
            if (hasOreFilter && !filter.isEmpty()) {
                this.setPartitionList((IPartitionList)new OreFilteredList(filter));
            } else {
                IItemList priorityList = AEApi.instance().storage().createItemList();
                for (int x = 0; x < config.func_70302_i_(); ++x) {
                    ItemStack is = config.func_70301_a(x);
                    if (is == null) continue;
                    priorityList.add((IAEStack)AEItemStack.create((ItemStack)is));
                }
                if (!priorityList.isEmpty()) {
                    if (hasFuzzy) {
                        this.setPartitionList((IPartitionList)new FuzzyPriorityList(priorityList, fzMode));
                    } else {
                        this.setPartitionList((IPartitionList)new PrecisePriorityList(priorityList));
                    }
                }
            }
        }
    }

    public boolean canGetInv() {
        return this.getCellInv() != null;
    }

    public long getTotalBytes() {
        return this.getCellInv().getTotalBytes();
    }

    public long getFreeBytes() {
        return this.getCellInv().getFreeBytes();
    }

    public long getUsedBytes() {
        return this.getCellInv().getUsedBytes();
    }

    public long getTotalTypes() {
        return this.getCellInv().getTotalItemTypes();
    }

    public long getFreeTypes() {
        return this.getCellInv().getRemainingItemTypes();
    }

    public long getUsedTypes() {
        return this.getCellInv().getStoredItemTypes();
    }

    public int getCellStatus() {
        return this.getStatusForCell();
    }

    public ICellCacheRegistry.TYPE getCellType() {
        return ICellCacheRegistry.TYPE.ITEM;
    }

    @Override
    public ITCellInventory getCellInv() {
        IMEInventory<?> o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = Ae2Reflect.getInternal((MEPassThrough)o);
        }
        return (ITCellInventory)(o instanceof ITCellInventory ? o : null);
    }

    @Override
    public boolean isPreformatted() {
        return !Ae2Reflect.getPartitionList(this).isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return Ae2Reflect.getPartitionList(this) instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }
}

