/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import com.asdflj.ae2thing.loader.IRegister;
import com.asdflj.ae2thing.loader.ItemAndBlockHolder;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.ItemEssence;
import thaumicenergistics.common.fluids.GaseousEssentia;

public class ItemPhial
extends ItemEssence
implements IRegister<ItemPhial> {
    public ItemPhial() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("ItemEssence");
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float f1, float f2, float f3) {
        return false;
    }

    @Override
    public ItemPhial register() {
        GameRegistry.registerItem((Item)this, (String)"phial", (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs tab, List par3List) {
        par3List.addAll(ItemPhial.getItems());
    }

    public static List<ItemStack> getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ItemAndBlockHolder.PHIAL, 1, 0));
        for (Aspect tag : Aspect.aspects.values()) {
            ItemStack i = new ItemStack((Item)ItemAndBlockHolder.PHIAL, 1, 1);
            ItemAndBlockHolder.PHIAL.setAspects(i, new AspectList().add(tag, 1));
            list.add(i);
        }
        return list;
    }

    public static IAEFluidStack getAeEssentiaStack(IAEItemStack item) {
        Aspect aspect = ItemPhial.getAspect(item);
        if (aspect == null) {
            return null;
        }
        return ItemPhial.newEssentiaStack(aspect, item.getStackSize());
    }

    public static FluidStack getEssentiaStack(ItemStack item) {
        Aspect aspect = ItemPhial.getAspect(item);
        if (aspect == null) {
            return null;
        }
        return ItemPhial.newEssentiaStack(aspect, item.field_77994_a).getFluidStack();
    }

    public static Aspect getAspect(IAEItemStack item) {
        return ItemPhial.getAspect(item.getItemStack());
    }

    public static IAEFluidStack newEssentiaStack(Aspect aspect, long size) {
        FluidStack fs = new FluidStack((Fluid)GaseousEssentia.getGasFromAspect((Aspect)aspect), 1);
        AEFluidStack ifs = AEFluidStack.create((Object)fs);
        ifs.setStackSize(size * (long)AspectUtil.R);
        return ifs;
    }

    @Nullable
    public static IAEItemStack newAeStack(@Nullable IAEFluidStack fluid) {
        if (fluid != null && fluid.getStackSize() >= 0L && fluid.getFluid() instanceof GaseousEssentia) {
            ItemStack phial = new ItemStack((Item)ItemAndBlockHolder.PHIAL, 1, 1);
            Aspect aspect = AspectUtil.getAspectFromGas((FluidStack)fluid.getFluidStack());
            ItemPhial.setAspects(phial, aspect);
            AEItemStack item = AEItemStack.create((ItemStack)phial);
            item.setStackSize(fluid.getStackSize() / (long)AspectUtil.R);
            return item;
        }
        return null;
    }

    public static ItemStack newStack(Aspect aspect, int size) {
        ItemStack is = new ItemStack((Item)ItemAndBlockHolder.PHIAL, size, 1);
        ItemPhial.setAspects(is, aspect, 1);
        return is;
    }

    public static Aspect getAspect(ItemStack item) {
        if (item.func_77973_b() instanceof ItemPhial && item.func_77942_o()) {
            Optional<Aspect> result;
            AspectList aspects = new AspectList();
            aspects.readFromNBT(item.func_77978_p());
            if (aspects.size() > 0 && (result = Arrays.stream(aspects.getAspects()).findFirst()).isPresent()) {
                return result.get();
            }
        }
        return null;
    }

    public static AspectList getAspectList(ItemStack item) {
        Aspect aspect = ItemPhial.getAspect(item);
        AspectList aspects = new AspectList();
        if (aspect == null) {
            return aspects;
        }
        aspects.add(aspect, item.field_77994_a);
        return aspects;
    }

    public static void setAspects(ItemStack item, Aspect aspect) {
        ItemPhial.setAspects(item, aspect, 1);
    }

    public static void setAspects(ItemStack item, Aspect aspect, int amount) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        AspectList list = new AspectList();
        list.add(aspect, amount);
        list.writeToNBT(item.func_77978_p());
    }

    public String func_77653_i(ItemStack itemStack) {
        Aspect aspect = ItemPhial.getAspect(itemStack);
        if (aspect == null) {
            return super.func_77653_i(itemStack);
        }
        return String.format("%s-%s", super.func_77653_i(itemStack), aspect.getName());
    }

    public static boolean isItemPhial(IAEItemStack item) {
        return item.getItem() instanceof ItemPhial;
    }

    public static boolean isItemPhial(ItemStack item) {
        return item.func_77973_b() instanceof ItemPhial;
    }
}

