/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.MagnetObject;
import com.asdflj.ae2thing.common.item.BaseItem;
import com.asdflj.ae2thing.common.item.IItemInventoryHandler;
import com.asdflj.ae2thing.common.storage.CellInventory;
import com.asdflj.ae2thing.common.storage.CellInventoryHandler;
import com.asdflj.ae2thing.common.storage.IStorageItemCell;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.BackpackTerminalInventory;
import com.asdflj.ae2thing.inventory.item.IItemInventory;
import com.asdflj.ae2thing.util.BlockPos;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBackpackTerminal
extends BaseItem
implements IItemInventory,
IStorageItemCell,
IItemInventoryHandler {
    public ItemBackpackTerminal() {
        this.func_77625_d(1);
        this.func_77655_b("backpack_terminal");
        this.func_111206_d(AE2Thing.resource("backpack_terminal").toString());
    }

    public ItemBackpackTerminal register() {
        GameRegistry.registerItem((Item)this, (String)"backpack_terminal", (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return !new MagnetObject(itemStack).isOff();
    }

    private String getMagnetMode(MagnetObject object) {
        String text;
        switch (object.getMode()) {
            case Inv: {
                text = I18n.func_135052_a((String)"ae2thing.magnet.inv", (Object[])new Object[0]);
                break;
            }
            case Backpack: {
                text = I18n.func_135052_a((String)"ae2thing.magnet.backpack", (Object[])new Object[0]);
                break;
            }
            default: {
                text = I18n.func_135052_a((String)"ae2thing.magnet.off", (Object[])new Object[0]);
            }
        }
        return text;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (player.func_70093_af()) {
            MagnetObject object = new MagnetObject(item);
            object.setNextMode();
            if (Platform.isClient()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(this.getMagnetMode(object)));
            }
        } else {
            InventoryHandler.openGui(player, w, new BlockPos(player.field_71071_by.field_70461_c, 0, 0), ForgeDirection.UNKNOWN, this.guiGuiType(item));
        }
        return item;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean hotbar) {
        MagnetObject object;
        if (!entity.func_70093_af() && entity.field_70173_aa % 10 == 0 && !(object = new MagnetObject(stack)).isOff()) {
            object.doMagnet(world, entity);
        }
    }

    @Override
    public Object getInventory(ItemStack stack, World world, int x, int y, int z, EntityPlayer player) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemInventoryHandler) {
            IItemInventoryHandler iih = (IItemInventoryHandler)item;
            try {
                return new BackpackTerminalInventory(stack, x, player, iih.getInventoryHandler(stack, null, player));
            }
            catch (AppEngException appEngException) {
                // empty catch block
            }
        }
        return null;
    }

    private GuiType guiGuiType(ItemStack item) {
        return GuiType.BACKPACK_TERMINAL;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getItem() == null || AE2ThingAPI.instance().isBlacklistedInStorage(requestedAddition.getItem());
    }

    public boolean isEditable(ItemStack is) {
        return false;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return null;
    }

    public IInventory getConfigInventory(ItemStack is) {
        return null;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return null;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    protected void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> toolTip, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, player, toolTip, displayMoreInfo);
        MagnetObject magnetObject = new MagnetObject(stack);
        toolTip.add(I18n.func_135052_a((String)"ae2thing.magnet.current_mode", (Object[])new Object[0]) + " " + this.getMagnetMode(magnetObject));
        if (GuiScreen.func_146272_n()) {
            toolTip.add(I18n.func_135052_a((String)"ae2thing.tooltip.backpack_terminal.desc", (Object[])new Object[0]));
        } else {
            toolTip.add(I18n.func_135052_a((String)"ae2thing.tooltip.shift_for_more", (Object[])new Object[0]));
        }
    }

    public IMEInventoryHandler<IAEItemStack> getInventoryHandler(ItemStack o, ISaveProvider container, EntityPlayer player) throws AppEngException {
        return new CellInventoryHandler(new CellInventory(o, container, player));
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

