/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IInterfaceViewable;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInterfaceTerminalUpdate;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.me.cache.CraftingGridCache;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.tile.inventory.InvOperation;
import appeng.tile.networking.TileCableBus;
import appeng.util.PatternMultiplierHelper;
import appeng.util.Platform;
import com.asdflj.ae2thing.client.gui.container.ContainerMonitor;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.client.gui.container.slot.SlotPatternFake;
import com.asdflj.ae2thing.client.gui.container.widget.IWidgetPatternContainer;
import com.asdflj.ae2thing.client.gui.container.widget.PatternContainer;
import com.asdflj.ae2thing.common.item.ItemPatternModifier;
import com.asdflj.ae2thing.inventory.IPatternTerminal;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import com.asdflj.ae2thing.inventory.item.PatternModifierInventory;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.util.Ae2Reflect;
import com.asdflj.ae2thing.util.GTUtil;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ContainerWirelessDualInterfaceTerminal
extends ContainerMonitor
implements IContainerCraftingPacket,
IWidgetPatternContainer,
IConfigurableObject {
    public final ContainerInterfaceTerminal delegateContainer;
    private final PatternContainer patternPanel;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean combine = false;
    @GuiSync(value=94)
    public boolean beSubstitute = false;
    @GuiSync(value=93)
    public boolean inverted;
    @GuiSync(value=92)
    public int activePage = 0;
    @GuiSync(value=91)
    public boolean prioritize = false;
    private final IPatternTerminal it;

    public ContainerWirelessDualInterfaceTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.patternPanel = new PatternContainer(ip, monitorable, this);
        this.delegateContainer = new ContainerInterfaceTerminal(ip, (IActionHost)monitorable);
        this.it = (IPatternTerminal)monitorable;
        this.setMonitor();
        this.lockSlot();
        this.bindPlayerInventory(ip, 14, 0);
    }

    private void lockSlot() {
        IPatternTerminal iPatternTerminal = this.it;
        if (iPatternTerminal instanceof WirelessTerminal) {
            WirelessTerminal wirelessTerminal = (WirelessTerminal)((Object)iPatternTerminal);
            this.lockPlayerInventorySlot(wirelessTerminal.getInventorySlot());
        }
    }

    @Override
    void setMonitor() {
        if (this.host instanceof INetworkTerminal) {
            IGridNode node = ((IGridHost)this.host).getGridNode(ForgeDirection.UNKNOWN);
            if (node != null) {
                this.networkNode = node;
                IGrid g = node.getGrid();
                if (g != null) {
                    this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                    this.monitor.setMonitor((IMEMonitor<IAEItemStack>)storageGrid.getItemInventory());
                    this.fluidMonitor.setMonitor((IMEMonitor<IAEFluidStack>)storageGrid.getFluidInventory(), (IMEMonitor<IAEItemStack>)storageGrid.getItemInventory());
                    this.monitor.setFluidMonitorObject(this.fluidMonitor);
                    if (this.monitor.getMonitor() == null) {
                        this.setValidContainer(false);
                    } else {
                        this.monitor.addListener();
                        this.fluidMonitor.addListener();
                        this.setCellInventory((IMEInventoryHandler)this.monitor.getMonitor());
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    public void func_75141_a(int slot, ItemStack item) {
        super.func_75141_a(slot, item);
        this.patternPanel.getAndUpdateOutput();
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        super.func_75131_a(par1ArrayOfItemStack);
        this.patternPanel.getAndUpdateOutput();
    }

    @Override
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        this.patternPanel.detectAndSendChanges();
        super.func_75142_b();
        this.delegateContainer.func_75142_b();
    }

    public void onSlotChange(Slot s) {
        if (this.patternPanel != null) {
            this.patternPanel.onSlotChange(s);
        } else {
            AELog.warn((String)"patternPanel is null!", (Object[])new Object[0]);
        }
        super.onSlotChange(s);
    }

    public void setInverted(boolean value) {
        this.inverted = value;
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        this.patternPanel.onUpdate(field, oldValue, newValue);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        try {
            if (id >= 0L) {
                this.delegateContainer.doAction(player, action, slotId, id);
            } else if (id == -1L) {
                Slot s = (Slot)this.field_75151_b.get(slotId);
                if (s instanceof SlotPatternFake || s instanceof SlotFakeCraftingMatrix || s instanceof SlotPatternTerm) {
                    if (action == InventoryAction.MOVE_REGION) {
                        super.doAction(player, InventoryAction.MOVE_REGION, slotId, id);
                        return;
                    }
                    if (action == InventoryAction.PICKUP_SINGLE) {
                        super.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, slotId, id);
                        return;
                    }
                    Slot slot = this.func_75139_a(slotId);
                    ItemStack stack = player.field_71071_by.func_70445_o();
                    if (Util.getFluidFromItem((ItemStack)stack) == null || Util.getFluidFromItem((ItemStack)stack).amount <= 0 || this.isCraftingMode()) {
                        super.doAction(player, action, slotId, id);
                        return;
                    }
                    if (this.validPatternSlot(slot) && (stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack))) {
                        FluidStack fluid = null;
                        switch (action) {
                            case PICKUP_OR_SET_DOWN: {
                                fluid = Util.getFluidFromItem((ItemStack)stack);
                                slot.func_75215_d(ItemFluidPacket.newStack((FluidStack)fluid));
                                break;
                            }
                            case SPLIT_OR_PLACE_SINGLE: {
                                fluid = Util.getFluidFromItem((ItemStack)Util.copyStackWithSize((ItemStack)stack, (int)1));
                                FluidStack origin = ItemFluidPacket.getFluidStack((ItemStack)slot.func_75211_c());
                                if (fluid != null && fluid.equals((Object)origin)) {
                                    fluid.amount += origin.amount;
                                    if (fluid.amount <= 0) {
                                        fluid = null;
                                    }
                                }
                                slot.func_75215_d(ItemFluidPacket.newStack((FluidStack)fluid));
                            }
                        }
                        if (fluid == null) {
                            super.doAction(player, action, slotId, id);
                        }
                    }
                }
            } else if (id == -2L) {
                super.doAction(player, action, slotId, id);
            }
        }
        catch (Exception e) {
            AELog.error((Throwable)e);
        }
    }

    protected boolean validPatternSlot(Slot slot) {
        return slot instanceof SlotPatternFake || slot instanceof SlotPatternOutputs;
    }

    public IGridNode getNetworkNode() {
        return this.it.getGridNode();
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.it.getInventoryByName(name);
    }

    public boolean useRealItems() {
        return false;
    }

    public ItemStack[] getViewCells() {
        return new ItemStack[0];
    }

    @Override
    public IPatternContainer getContainer() {
        return this.patternPanel;
    }

    public List<ICrafting> getCrafters() {
        return this.field_75149_d;
    }

    public void doubleStacks(int value, NBTTagCompound tag) {
        ImmutablePair<World, IInterfaceViewable> result = this.getWorldAndHost(tag);
        if (result == null) {
            return;
        }
        this.doublePatterns(value, (World)result.left, (IInterfaceViewable)result.right);
    }

    private ImmutablePair<World, IInterfaceViewable> getWorldAndHost(NBTTagCompound tag) {
        IInterfaceViewable host;
        Util.DimensionalCoordSide intMsg = Util.DimensionalCoordSide.readFromNBT((NBTTagCompound)tag);
        WorldServer w = DimensionManager.getWorld((int)intMsg.getDimension());
        TileEntity tile = w.func_147438_o(intMsg.x, intMsg.y, intMsg.z);
        if (tile instanceof TileCableBus) {
            host = (IInterfaceViewable)((TileCableBus)tile).getPart(intMsg.getSide());
        } else if (tile instanceof IInterfaceViewable) {
            IInterfaceViewable iv;
            host = iv = (IInterfaceViewable)tile;
        } else if (ModAndClassUtil.GT5 || ModAndClassUtil.GT5NH) {
            host = GTUtil.getIInterfaceViewable(tile);
            if (host == null) {
                return null;
            }
        } else {
            return null;
        }
        return ImmutablePair.of((Object)w, (Object)host);
    }

    private void doublePatterns(int val, World w, IInterfaceViewable host) {
        IInventory patterns = host.getPatterns();
        boolean fast = (val & 1) != 0;
        boolean backwards = (val & 2) != 0;
        CraftingGridCache.pauseRebuilds();
        try {
            for (int i = 0; i < patterns.func_70302_i_(); ++i) {
                int max;
                ICraftingPatternItem cpi;
                ICraftingPatternDetails details;
                Item item;
                ItemStack stack = patterns.func_70301_a(i);
                if (stack == null || !((item = stack.func_77973_b()) instanceof ICraftingPatternItem) || (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(stack, w)) == null || details.isCraftable()) continue;
                int n = max = backwards ? PatternMultiplierHelper.getMaxBitDivider((ICraftingPatternDetails)details) : PatternMultiplierHelper.getMaxBitMultiplier((ICraftingPatternDetails)details);
                if (max <= 0) continue;
                ItemStack copy = stack.func_77946_l();
                PatternMultiplierHelper.applyModification((ItemStack)copy, (int)((fast ? Math.min(3, max) : 1) * (backwards ? -1 : 1)));
                patterns.func_70299_a(i, copy);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CraftingGridCache.unpauseRebuilds();
        this.sendToClient(host);
    }

    private void sendToClient(IInterfaceViewable host) {
        PacketInterfaceTerminalUpdate update = new PacketInterfaceTerminalUpdate();
        Map map = Ae2Reflect.getTracked(this.delegateContainer);
        Object o = map.get(host);
        if (o == null) {
            return;
        }
        try {
            Field f = o.getClass().getDeclaredField("id");
            f.setAccessible(true);
            long id = (Long)f.get(o);
            Method m = o.getClass().getDeclaredMethod("updateNBT", new Class[0]);
            m.setAccessible(true);
            m.invoke(o, new Object[0]);
            Field f1 = o.getClass().getDeclaredField("invNbt");
            f1.setAccessible(true);
            NBTTagList tag = (NBTTagList)f1.get(o);
            int[] size = new int[host.rowSize() * host.rows()];
            for (int i = 0; i < size.length; ++i) {
                size[i] = i;
            }
            update.addOverwriteEntry(id).setOnline(true).setItems(size, tag);
            update.encode();
            NetworkHandler.instance.sendTo((AppEngPacket)update, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addMESlotToContainer(AppEngSlot s) {
        this.func_75146_a((Slot)s);
    }

    public void setStick(NBTTagCompound tag) {
        Util.DimensionalCoordSide c = Util.DimensionalCoordSide.readFromNBT((NBTTagCompound)tag);
        WorldServer w = DimensionManager.getWorld((int)c.getDimension());
        if (ModAndClassUtil.GT5 || ModAndClassUtil.GT5NH) {
            GTUtil.setDataStick(c.x, c.y, c.z, this.player, (World)w);
        }
    }

    @Override
    public void processItemList() {
        super.processItemList();
        this.fluidMonitor.processItemList();
    }

    @Override
    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        this.fluidMonitor.removeCraftingFromCrafters(c);
    }

    @Override
    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.fluidMonitor.queueInventory(c);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.fluidMonitor.getMonitor() != null) {
            this.fluidMonitor.removeListener();
        }
    }

    public void saveChanges() {
        if (Platform.isServer()) {
            this.it.saveSettings();
        }
    }

    public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer player) {
        if (slotId == -999) {
            return this.getPlayerInv().func_70445_o();
        }
        return super.func_75144_a(slotId, clickedButton, mode, player);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    public void setCrafting(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.it.setCraftingRecipe(craftingMode);
    }

    public void setModifier(int val, NBTTagCompound tag) {
        ImmutablePair<World, IInterfaceViewable> result = this.getWorldAndHost(tag);
        if (result == null) {
            return;
        }
        ItemStack currentItem = this.player.field_71071_by.func_70445_o();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemPatternModifier) {
            boolean backwards;
            int slot = val >> 2;
            boolean shift = (val & 1) != 0;
            boolean bl = backwards = (val & 2) != 0;
            if (!backwards) {
                this.injectPatternToPatternModifier((IInterfaceViewable)result.right, slot, shift);
            } else {
                this.extractPatternToInterface((IInterfaceViewable)result.right);
            }
            this.sendToClient((IInterfaceViewable)result.right);
        }
    }

    private void extractPatternToInterface(IInterfaceViewable host) {
        PatternModifierInventory patternModifierInventory = new PatternModifierInventory(this.player.field_71071_by.func_70445_o(), -1, this.player);
        patternModifierInventory.extractToHost(host);
    }

    private void injectPatternToPatternModifier(IInterfaceViewable host, int slot, boolean shift) {
        IInventory patterns = host.getPatterns();
        PatternModifierInventory patternModifierInventory = new PatternModifierInventory(this.player.field_71071_by.func_70445_o(), -1, this.player);
        if (shift) {
            ItemStack pattern;
            for (int i = 0; i < patterns.func_70302_i_() && patternModifierInventory.injectItems(pattern = patterns.func_70301_a(i)); ++i) {
                patterns.func_70299_a(i, null);
            }
        } else if (patternModifierInventory.injectItems(patterns.func_70301_a(slot))) {
            patterns.func_70299_a(slot, null);
        }
    }
}

