/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.TickHandler;
import appeng.me.Grid;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.container.BaseNetworkContainer;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import com.asdflj.ae2thing.network.SPacketWirelessConnectorUpdate;
import com.asdflj.ae2thing.util.Util;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.bdew.ae2stuff.grid.Security;
import net.bdew.ae2stuff.machines.wireless.TileWireless;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ContainerWirelessConnectorTerminal
extends BaseNetworkContainer
implements INetworkTerminal {
    private final List<TileWireless> wirelessTiles = new ArrayList<TileWireless>();

    public ContainerWirelessConnectorTerminal(InventoryPlayer ip, ITerminalHost host) {
        super(ip, host);
    }

    public void updateData() {
        if (Platform.isServer()) {
            this.wirelessTiles.clear();
            if (!this.hasPower) {
                return;
            }
            if (this.getGrid() == null) {
                return;
            }
            int playerID = Security.getPlayerId((GameProfile)this.player.func_146103_bH());
            for (Grid grid : TickHandler.INSTANCE.getGridList()) {
                IMachineSet set = grid.getMachines(TileWireless.class);
                if (set.isEmpty()) continue;
                for (IGridNode node : set) {
                    TileWireless tile = (TileWireless)node.getGridBlock();
                    if (this.getGrid() != null && this.getGrid().equals(grid)) {
                        this.wirelessTiles.add(tile);
                        continue;
                    }
                    int id = node.getPlayerID();
                    if (id == -1 || id != playerID) continue;
                    this.wirelessTiles.add(tile);
                }
            }
            this.sendToPlayer();
        }
    }

    private void sendToPlayer() {
        AE2Thing.proxy.netHandler.sendTo(new SPacketWirelessConnectorUpdate(this.wirelessTiles), (EntityPlayerMP)this.player);
    }

    @Override
    public void func_75132_a(ICrafting crafting) {
        super.func_75132_a(crafting);
        this.updateData();
    }

    public void doLink(TileWireless left, TileWireless right) {
        if (left == null || right == null || left == right) {
            return;
        }
        if (left.isLinked()) {
            left.doUnlink();
        }
        if (right.isLinked()) {
            right.doUnlink();
        }
        try {
            left.doLink(right);
        }
        catch (Exception e) {
            left.doUnlink();
            right.doUnlink();
            ChatComponentText s = new ChatComponentText(I18n.func_135052_a((String)"ae2stuff.wireless.tool.failed", (Object[])new Object[0]) + ": " + e.getMessage());
            s.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            this.player.func_146105_b((IChatComponent)s);
        }
    }

    public void doUnlink(TileWireless tile) {
        if (tile == null) {
            return;
        }
        if (tile.isLinked()) {
            tile.doUnlink();
        }
    }

    public void setName(String name, NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        DimensionalCoord d = DimensionalCoord.readFromNBT((NBTTagCompound)tag);
        for (TileWireless tile : this.wirelessTiles) {
            if (!Util.isSameDimensionalCoord(tile.getLocation(), d)) continue;
            tile.setCustomName(name);
            this.sendToPlayer();
        }
    }

    public void bind(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        DimensionalCoord a = DimensionalCoord.readFromNBT((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("#0")));
        DimensionalCoord b = DimensionalCoord.readFromNBT((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("#1")));
        TileWireless ta = null;
        TileWireless tb = null;
        for (TileWireless tile : this.wirelessTiles) {
            if (Util.isSameDimensionalCoord(tile.getLocation(), a)) {
                ta = tile;
            } else if (Util.isSameDimensionalCoord(tile.getLocation(), b)) {
                tb = tile;
            }
            if (ta == null || tb == null) continue;
            this.doLink(ta, tb);
            this.sendToPlayer();
        }
    }

    public void unBind(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        DimensionalCoord d = DimensionalCoord.readFromNBT((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("#0")));
        for (TileWireless tile : this.wirelessTiles) {
            if (!Util.isSameDimensionalCoord(tile.getLocation(), d)) continue;
            this.doUnlink(tile);
            this.sendToPlayer();
        }
    }

    public void setColor(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        NBTTagCompound data = (NBTTagCompound)tag.func_74781_a("#0");
        DimensionalCoord a = DimensionalCoord.readFromNBT((NBTTagCompound)data);
        AEColor color = AEColor.values()[data.func_74765_d("color")];
        for (TileWireless tile : this.wirelessTiles) {
            if (!Util.isSameDimensionalCoord(tile.getLocation(), a)) continue;
            tile.color_$eq(color);
            tile.getWorldObject().func_147471_g(a.x, a.y, a.z);
            this.sendToPlayer();
        }
    }

    @Override
    public IGrid getGrid() {
        return this.getGridNode().getGrid();
    }

    @Override
    public IGridNode getGridNode() {
        return this.getActionHost().getActionableNode();
    }
}

