/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.IScrollSource;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import com.asdflj.ae2thing.client.gui.container.ContainerWirelessConnectorTerminal;
import com.asdflj.ae2thing.client.gui.widget.Component;
import com.asdflj.ae2thing.client.gui.widget.IClickable;
import com.asdflj.ae2thing.client.gui.widget.IScrollable;
import com.asdflj.ae2thing.client.gui.widget.METextField;
import com.asdflj.ae2thing.client.gui.widget.THGuiTextField;
import com.asdflj.ae2thing.client.me.IDisplayRepo;
import com.asdflj.ae2thing.client.me.WirelessConnectorRepo;
import com.asdflj.ae2thing.util.Info;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiWirelessConnectorTerminal
extends AEBaseGui {
    private final int reservedSpace;
    public static String memoryText = "";
    private int maxRows;
    private int perRow;
    protected int standardSize;
    private int rows;
    protected THGuiTextField searchField;
    protected final IDisplayRepo repo;
    private final List<Component> components = new ArrayList<Component>();
    private final List<IClickable> clickables = new ArrayList<IClickable>();
    private final List<IScrollable> scrollables = new ArrayList<IScrollable>();
    private final ContainerWirelessConnectorTerminal container = (ContainerWirelessConnectorTerminal)this.field_147002_h;

    public GuiWirelessConnectorTerminal(InventoryPlayer inventory, ITerminalHost inv) {
        super((Container)new ContainerWirelessConnectorTerminal(inventory, inv));
        this.field_146999_f = 195;
        this.field_147000_g = 204;
        this.standardSize = this.field_146999_f;
        this.reservedSpace = 10;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new WirelessConnectorRepo((IScrollSource)scrollbar);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.Terminal.getLocal()), 8, 6, 0x404040);
        for (IClickable clickable : this.clickables) {
            METextField tf;
            if (!(clickable instanceof METextField) || !(tf = (METextField)clickable).isMouseIn(mouseX, mouseY)) continue;
            tf.drawNameMask();
            break;
        }
        for (Component com : this.components) {
            com.draw();
        }
        for (Component com : this.components) {
            com.drawSelection(mouseX, mouseY);
        }
    }

    public void bindTextureBack(String file) {
        ResourceLocation loc = new ResourceLocation("ae2thing", "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.maxRows = this.getMaxRows();
        this.perRow = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? 1 : 1 + (this.field_146294_l - this.standardSize) / 42;
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        boolean NEI2 = false;
        int top = hasNEI ? 22 : 0;
        int magicNumber = 0;
        int extraSpace = this.field_146295_m - magicNumber - 0 - top - this.reservedSpace;
        this.rows = (int)Math.floor((double)extraSpace / 42.0);
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (this.rows < 3) {
            this.rows = 3;
        }
        super.func_73866_w_();
        this.field_147000_g = magicNumber + this.rows * 42 + this.reservedSpace;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = unusedSpace < 0 ? 0 : unusedSpace % 10;
        this.components.clear();
        this.clickables.clear();
        this.scrollables.clear();
        for (int i = 0; i < this.rows; ++i) {
            this.components.add(new Component(this.repo, i, this, 28, 20));
        }
        this.getClickables().sort((o1, o2) -> o2.getIndex() - o1.getIndex());
        this.searchField = new THGuiTextField(this.field_146289_q, this.field_147003_i + 69, this.field_147009_r + 4, 102, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        this.searchField.setMessage(ButtonToolTips.SearchStringTooltip.getLocal());
        this.setSearchString(memoryText, false);
        this.setScrollBar();
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        super.func_73863_a(mouseX, mouseY, btn);
        if (AEConfig.instance.preserveSearchBar && this.searchField != null) {
            this.handleTooltip(mouseX, mouseY, this.searchField.getTooltipProvider());
        }
        if (this.searchField != null && this.searchField.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(this.field_147003_i, this.field_147000_g, 0, I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.search_tooltip", (Object[])new Object[0]).replace("\\n", "\n"));
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.searchField.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.setSearchString("", true);
        }
        IClickable lastClickable = null;
        for (IClickable click : this.getClickables()) {
            if (!click.mouseClicked(xCoord, yCoord)) continue;
            click.onClick();
            lastClickable = click;
            break;
        }
        IClickable finalLastClickable = lastClickable;
        this.getClickables().stream().filter(c -> c != null && finalLastClickable != c).forEach(IClickable::unfocused);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void setSearchString(String memoryText, boolean updateView) {
        this.searchField.func_146180_a(memoryText);
        this.repo.setSearchString(memoryText);
        if (updateView) {
            this.repo.updateView();
            this.setScrollBar();
        }
    }

    private int getMaxRows() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        memoryText = this.searchField.func_146179_b();
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            for (Component com : this.components) {
                if (!com.isFocused()) continue;
                com.textboxKeyTyped(character, key);
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 42);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, 1);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTextureBack(this.getBackground());
        int x_width = 195;
        this.func_73729_b(offsetX, offsetY, 0, 0, 195, 18);
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 42, 0, 18, 195, 42);
        }
        this.func_73729_b(offsetX, offsetY + 18 + this.rows * 42, 0, 144, 195, 8);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    protected boolean mouseWheelEvent(int x, int y, int wheel) {
        for (IScrollable scrollable : this.getScrollables()) {
            if (!scrollable.scroll(x, y, wheel)) continue;
            return true;
        }
        return super.mouseWheelEvent(x, y, wheel);
    }

    public String getBackground() {
        return "gui/wireless_connector.png";
    }

    public void postUpdate(List<Info> list) {
        this.repo.clear();
        for (Info info : list) {
            this.repo.postUpdate(info);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    public List<IClickable> getClickables() {
        return this.clickables;
    }

    public List<IScrollable> getScrollables() {
        return this.scrollables;
    }

    protected boolean isPowered() {
        return this.container.hasPower;
    }
}

