/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api.adapter.crafting;

import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.asdflj.ae2thing.api.adapter.crafting.ICraftingTerminalAdapter;
import com.glodblock.github.client.gui.GuiFluidCraftingWireless;
import com.glodblock.github.client.gui.container.ContainerCraftingWireless;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.nei.FluidPatternTerminalRecipeTransferHandler;
import com.glodblock.github.util.BlockPos;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FCCraftingTerminal
implements ICraftingTerminalAdapter {
    private static boolean isRegisteredHandler = false;

    @Override
    public void openGui(EntityPlayerMP player, TileEntity tile, ForgeDirection face, Object target) {
        InventoryHandler.openGui((EntityPlayer)player, (World)player.field_70170_p, (BlockPos)new BlockPos(((IWirelessTerminal)target).getInventorySlot(), 0, 0), (ForgeDirection)Objects.requireNonNull(face), (GuiType)GuiType.FLUID_CRAFTING_CONFIRM_ITEM);
    }

    @Override
    public Class<? extends Container> getContainer() {
        return ContainerCraftingWireless.class;
    }

    @Override
    public void moveItems(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        if (isRegisteredHandler) {
            return;
        }
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (firstGui instanceof GuiFluidCraftingWireless && FluidPatternTerminalRecipeTransferHandler.craftSet.contains(recipe.getOverlayIdentifier())) {
                PacketNEIRecipe packet = new PacketNEIRecipe(this.packIngredients(firstGui, ingredients));
                NetworkHandler.instance.sendToServer((AppEngPacket)packet);
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private static void checkIsRegisterHandler() {
        try {
            Class.forName("com.glodblock.github.nei.FluidCraftingTransferHandler");
            isRegisteredHandler = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients) throws IOException {
        NBTTagCompound recipe = new NBTTagCompound();
        block0: for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            for (Object o : gui.field_147002_h.field_75151_b) {
                Slot slot;
                if (!(o instanceof SlotCraftingMatrix) && !(o instanceof SlotFakeCraftingMatrix) || (slot = (Slot)o).getSlotIndex() != col + row * 3) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (int x = 0; x < positionedStack.items.length; ++x) {
                    if (Platform.isRecipePrioritized((ItemStack)positionedStack.items[x])) {
                        list.add(0, positionedStack.items[x]);
                        continue;
                    }
                    list.add(positionedStack.items[x]);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                continue block0;
            }
        }
        return recipe;
    }

    static {
        FCCraftingTerminal.checkIsRegisterHandler();
    }
}

