/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api.adapter.crafting;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.integration.modules.NEIHelpers.NEICraftingHandler;
import appeng.util.Platform;
import codechicken.nei.recipe.IRecipeHandler;
import com.asdflj.ae2thing.api.adapter.crafting.ICraftingTerminalAdapter;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AECraftingTerminal
implements ICraftingTerminalAdapter {
    @Override
    public boolean isTile() {
        return true;
    }

    @Override
    public void openGui(EntityPlayerMP player, TileEntity tile, ForgeDirection face, Object target) {
        Platform.openGUI((EntityPlayer)player, (TileEntity)tile, (ForgeDirection)face, (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM);
    }

    @Override
    public Class<? extends Container> getContainer() {
        return ContainerCraftingTerm.class;
    }

    @Override
    public void moveItems(GuiContainer gui, IRecipeHandler recipe, int recipeIndex) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (gui instanceof GuiCraftingTerm) {
                PacketNEIRecipe packet = new PacketNEIRecipe(NEICraftingHandler.packIngredients((GuiContainer)gui, (List)ingredients, (boolean)false));
                if (packet.size() >= 32768) {
                    AELog.warn((String)("Recipe for " + recipe.getRecipeName() + " has too many variants, reduced version will be used"), (Object[])new Object[0]);
                    packet = new PacketNEIRecipe(NEICraftingHandler.packIngredients((GuiContainer)gui, (List)ingredients, (boolean)true));
                }
                NetworkHandler.instance.sendToServer((AppEngPacket)packet);
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }
}

