/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.WorldCoord;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.tile.networking.TileWireless;
import appeng.util.Platform;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.common.item.ItemWirelessConnectorTerminal;
import com.asdflj.ae2thing.common.item.ItemWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WirelessObject
implements IActionHost {
    private final ItemStack item;
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final EntityPlayer player;
    private IGridNode gridNode;
    private IGrid grid;
    private IEnergySource energySource;
    private IMEMonitor<IAEItemStack> itemInv;
    private IMEMonitor<IAEFluidStack> fluidInv;
    private WirelessTerminal wirelessTerminal;
    private PlayerSource source;

    public WirelessObject(ItemStack item, World world, int x, int y, int z, EntityPlayer player) throws AppEngException {
        this.item = item;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.player = player;
        if (Platform.isServer()) {
            this.gridNode = this.getWirelessGrid();
            if (this.gridNode == null || !this.rangeCheck()) {
                throw new AppEngException(PlayerMessages.OutOfRange.get().toString());
            }
            this.grid = this.gridNode.getGrid();
            IStorageGrid iStorageGrid = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
            this.itemInv = iStorageGrid.getItemInventory();
            this.fluidInv = iStorageGrid.getFluidInventory();
            this.source = new PlayerSource(this.player, (IActionHost)this);
        }
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.itemInv;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.fluidInv;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public IGridNode getGridNode() {
        return this.gridNode;
    }

    public int getSlot() {
        return this.x;
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setEnergySource(IEnergySource energySource) {
        this.energySource = energySource;
    }

    public boolean rangeCheck() {
        Item i;
        if (this.getItemStack() != null && this.getItemStack().func_77973_b() != null && ((i = this.getItemStack().func_77973_b()) instanceof ItemWirelessConnectorTerminal ? Config.wirelessConnectorTerminalInfinityConnectionRange : i instanceof ItemWirelessDualInterfaceTerminal && this.hasInfinityBoosterCard())) {
            return true;
        }
        boolean canConnect = false;
        for (IGridNode node : this.gridNode.getGrid().getMachines(TileWireless.class)) {
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node.getMachine();
            if (!accessPoint.isActive() || accessPoint.getLocation().getDimension() != this.player.field_71093_bK) continue;
            WorldCoord distance = accessPoint.getLocation().subtract((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
            int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
            if (!((double)squaredDistance <= accessPoint.getRange() * accessPoint.getRange())) continue;
            canConnect = true;
            break;
        }
        return canConnect;
    }

    public Object getInventory(Class<?> obj) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.wirelessTerminal == null) {
            this.wirelessTerminal = (WirelessTerminal)obj.getConstructor(WirelessObject.class).newInstance(this);
        }
        return this.wirelessTerminal;
    }

    public IGridNode getWirelessGrid() {
        if (this.item.func_77973_b() instanceof ToolWirelessTerminal) {
            String key = ((ToolWirelessTerminal)this.item.func_77973_b()).getEncryptionKey(this.item);
            IGridHost securityTerminal = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(Long.parseLong(key));
            if (securityTerminal == null) {
                return null;
            }
            return securityTerminal.getGridNode(ForgeDirection.UNKNOWN);
        }
        return null;
    }

    private void closeGui() {
        this.player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
        this.player.func_71053_j();
    }

    public int extractPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier, int ticks) {
        double result;
        if (this.hasEnergyCard()) {
            return 0;
        }
        if (mode == Actionable.SIMULATE) {
            return ticks;
        }
        if (ticks < 10) {
            return ++ticks;
        }
        if (this.energySource == null) {
            this.closeGui();
        }
        if ((result = this.energySource.extractAEPower(amt, mode, usePowerMultiplier)) == 0.0) {
            this.closeGui();
        }
        this.player.field_71071_by.func_70299_a(this.getSlot(), this.getItemStack());
        ticks = 0;
        return ticks;
    }

    public static boolean hasInfinityBoosterCard(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        return WirelessObject.hasInfinityBoosterCard(tag);
    }

    private static boolean hasInfinityBoosterCard(NBTTagCompound data) {
        return data.func_74764_b("infinityBoosterCard") && data.func_74767_n("infinityBoosterCard");
    }

    public boolean hasInfinityBoosterCard() {
        return WirelessObject.hasInfinityBoosterCard(this.item);
    }

    public static boolean hasEnergyCard(ItemStack is) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)is);
        return WirelessObject.hasEnergyCard(data);
    }

    private static boolean hasEnergyCard(NBTTagCompound data) {
        return data.func_74764_b("InfinityEnergyCard") && data.func_74767_n("InfinityEnergyCard");
    }

    public boolean hasEnergyCard() {
        return WirelessObject.hasEnergyCard(this.item);
    }

    public IGridNode getActionableNode() {
        return this.gridNode;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.gridNode;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public void securityBreak() {
        this.getGridNode(ForgeDirection.UNKNOWN).getMachine().securityBreak();
    }

    public PlayerSource getSource() {
        return this.source;
    }
}

