/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import com.asdflj.ae2thing.api.adapter.terminal.item.BackpackTerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.DualInterfaceTerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.FCBaseItemTerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.FCUltraTerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.IItemTerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.TerminalItems;
import com.asdflj.ae2thing.api.adapter.terminal.item.WCTWirelessCraftingTerminal;
import com.asdflj.ae2thing.client.event.OpenTerminalEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class TerminalMenu {
    public static List<IItemTerminal> terminalHandlers = new ArrayList<IItemTerminal>();
    private final List<TerminalItems> terminalItems = new ArrayList<TerminalItems>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    public TerminalMenu() {
        for (IItemTerminal handler : terminalHandlers) {
            this.terminalItems.addAll(handler.getTerminalItems());
        }
        for (TerminalItems t : this.terminalItems) {
            this.items.add(t.getTargetItem());
        }
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public List<TerminalItems> getTerminalItems() {
        return this.terminalItems;
    }

    public void OpenTerminal(int index) {
        try {
            if (index < 0 || index >= this.terminalItems.size()) {
                return;
            }
            TerminalItems terminal = this.terminalItems.get(index);
            MinecraftForge.EVENT_BUS.post((Event)new OpenTerminalEvent(terminal));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        terminalHandlers.add(FCUltraTerminal.instance);
        terminalHandlers.add(FCBaseItemTerminal.instance);
        terminalHandlers.add(DualInterfaceTerminal.instance);
        terminalHandlers.add(WCTWirelessCraftingTerminal.instance);
        terminalHandlers.add(BackpackTerminal.instance);
    }
}

